/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.ArrayList;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.components.flow.Interpreter;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.CategoryNode;
import org.apache.cocoon.components.treeprocessor.CategoryNodeBuilder;
import org.apache.cocoon.components.treeprocessor.LinkedProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.sitemap.CallFunctionNode;
import org.apache.cocoon.components.treeprocessor.sitemap.CallNode;
import org.apache.cocoon.components.treeprocessor.sitemap.FlowNode;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolverFactory;

public class CallNodeBuilder
extends AbstractProcessingNodeBuilder
implements LinkedProcessingNodeBuilder {
    protected ProcessingNode node;
    protected String resourceName;
    protected String functionName;
    protected String continuationId;

    public ProcessingNode buildNode(Configuration config) throws Exception {
        this.resourceName = config.getAttribute("resource", null);
        this.functionName = config.getAttribute("function", null);
        this.continuationId = config.getAttribute("continuation", null);
        if (this.resourceName == null) {
            if (this.functionName == null && this.continuationId == null) {
                throw new ConfigurationException("<map:call> must have either a 'resource', 'function' or 'continuation' attribute, at " + config.getLocation());
            }
            ArrayList<String> argumentNames = new ArrayList<String>();
            Configuration[] params = config.getChildren("parameter");
            for (int i = 0; i < params.length; ++i) {
                argumentNames.add(params[i].getAttribute("name"));
            }
            this.node = new CallFunctionNode(VariableResolverFactory.getResolver(this.functionName, this.manager), VariableResolverFactory.getResolver(this.continuationId, this.manager), argumentNames.toArray(new String[argumentNames.size()]));
        } else {
            if (this.functionName != null || this.continuationId != null) {
                throw new ConfigurationException("<map:call> cannot have both a 'resource' and a 'function' or 'continuation' attribute, at " + config.getLocation());
            }
            this.node = new CallNode();
        }
        this.treeBuilder.setupNode(this.node, config);
        if (this.node instanceof Configurable) {
            ((Configurable)this.node).configure(config);
        }
        return this.node;
    }

    public void linkNode() throws Exception {
        if (this.resourceName != null) {
            CategoryNode resources = CategoryNodeBuilder.getCategoryNode(this.treeBuilder, "resources");
            if (resources == null) {
                throw new ConfigurationException("This sitemap contains no resources. Cannot call at " + this.node.getLocation());
            }
            ((CallNode)this.node).setResource(resources, VariableResolverFactory.getResolver(this.resourceName, this.manager));
        } else {
            FlowNode flow = (FlowNode)this.treeBuilder.getRegisteredNode("flow");
            if (flow == null) {
                throw new ConfigurationException("This sitemap contains no control flows defined, cannot call at " + this.node.getLocation() + ". Define a control flow using <map:flow>, with embedded <map:script> elements.");
            }
            Interpreter interpreter = flow.getInterpreter();
            ((CallFunctionNode)this.node).setInterpreter(interpreter);
        }
    }
}

