/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.core.container.DefaultServiceSelector;
import org.apache.cocoon.generation.GeneratorFactory;
import org.apache.cocoon.serialization.SerializerFactory;
import org.apache.cocoon.transformation.TransformerFactory;

public class ComponentsSelector
extends DefaultServiceSelector {
    private static final int UNKNOWN = -1;
    private static final int GENERATOR = 0;
    private static final int TRANSFORMER = 1;
    private static final int SERIALIZER = 2;
    private static final int READER = 3;
    private static final int MATCHER = 4;
    private static final int SELECTOR = 5;
    private static final int ACTION = 6;
    private static final int PIPELINE = 7;
    private static final String[] CONFIG_NAMES = new String[]{"generators", "transformers", "serializers", "readers", "matchers", "selectors", "actions", "pipes"};
    private static final String[] COMPONENT_NAMES = new String[]{"generator", "transformer", "serializer", "reader", "matcher", "selector", "action", "pipe"};
    private int roleId;

    protected String getComponentInstanceName() {
        return COMPONENT_NAMES[this.roleId];
    }

    protected String getClassAttributeName() {
        return "src";
    }

    public void configure(Configuration config) throws ConfigurationException {
        String configName = config.getName();
        this.roleId = -1;
        for (int i = 0; i < CONFIG_NAMES.length; ++i) {
            if (!CONFIG_NAMES[i].equals(configName)) continue;
            this.roleId = i;
            break;
        }
        if (this.roleId == -1) {
            throw new ConfigurationException("ComponentsSelector is reserved for sitemap components. Illegal use at " + config.getLocation());
        }
        super.configure(config);
    }

    public Object select(Object hint) throws ServiceException {
        Object component = super.select(hint);
        switch (this.roleId) {
            case 0: {
                if (!(component instanceof GeneratorFactory)) break;
                return ((GeneratorFactory)component).getInstance();
            }
            case 1: {
                if (!(component instanceof TransformerFactory)) break;
                return ((TransformerFactory)component).getInstance();
            }
            case 2: {
                if (!(component instanceof SerializerFactory)) break;
                return ((SerializerFactory)component).getInstance();
            }
        }
        return component;
    }

    public void release(Object component) {
        switch (this.roleId) {
            case 0: {
                if (!(component instanceof GeneratorFactory.Instance)) break;
                ContainerUtil.dispose((Object)component);
                component = ((GeneratorFactory.Instance)component).getFactory();
                break;
            }
            case 1: {
                if (!(component instanceof TransformerFactory.Instance)) break;
                ContainerUtil.dispose((Object)component);
                component = ((TransformerFactory.Instance)component).getFactory();
                break;
            }
            case 2: {
                if (!(component instanceof SerializerFactory.Instance)) break;
                ContainerUtil.dispose((Object)component);
                component = ((SerializerFactory.Instance)component).getFactory();
            }
        }
        super.release(component);
    }
}

