/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.TreeProcessor;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;
import org.apache.commons.lang.BooleanUtils;

public class MountNode
extends AbstractProcessingNode
implements Disposable {
    protected static final String COCOON_PASS_THROUGH = "COCOON_PASS_THROUGH";
    private final VariableResolver prefix;
    private final VariableResolver source;
    private Map processors = new HashMap();
    private final TreeProcessor parentProcessor;
    private final boolean checkReload;
    private final boolean passThrough;

    public MountNode(VariableResolver prefix, VariableResolver source, TreeProcessor parentProcessor, boolean checkReload, boolean passThrough) {
        this.prefix = prefix;
        this.source = source;
        this.parentProcessor = parentProcessor;
        this.checkReload = checkReload;
        this.passThrough = passThrough;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        Object oldPassThrough;
        String oldURI;
        String oldPrefix;
        TreeProcessor processor;
        block13: {
            block14: {
                Map objectModel = env.getObjectModel();
                String resolvedSource = this.source.resolve(context, objectModel);
                String resolvedPrefix = this.prefix.resolve(context, objectModel);
                if (resolvedSource.length() == 0) {
                    throw new ProcessingException("Source of mount statement is empty");
                }
                resolvedSource = this.executor.enterSitemap(this, objectModel, resolvedSource);
                processor = this.getProcessor(resolvedSource, resolvedPrefix);
                oldPrefix = env.getURIPrefix();
                oldURI = env.getURI();
                oldPassThrough = env.getAttribute(COCOON_PASS_THROUGH);
                env.setAttribute(COCOON_PASS_THROUGH, BooleanUtils.toBooleanObject((boolean)this.passThrough));
                try {
                    processor.getEnvironmentHelper().changeContext(env);
                    if (!context.isBuildingPipelineOnly()) break block13;
                    Processor.InternalPipelineDescription pp = processor.buildPipeline(env);
                    if (pp == null) break block14;
                    context.setInternalPipelineDescription(pp);
                    boolean bl = true;
                    Object var13_14 = null;
                    env.setURI(oldPrefix, oldURI);
                    if (oldPassThrough != null) {
                        env.setAttribute(COCOON_PASS_THROUGH, oldPassThrough);
                    } else {
                        env.removeAttribute(COCOON_PASS_THROUGH);
                    }
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var13_17 = null;
                    env.setURI(oldPrefix, oldURI);
                    if (oldPassThrough != null) {
                        env.setAttribute(COCOON_PASS_THROUGH, oldPassThrough);
                    } else {
                        env.removeAttribute(COCOON_PASS_THROUGH);
                    }
                    throw throwable;
                }
            }
            boolean bl = false;
            Object var13_15 = null;
            env.setURI(oldPrefix, oldURI);
            if (oldPassThrough != null) {
                env.setAttribute(COCOON_PASS_THROUGH, oldPassThrough);
            } else {
                env.removeAttribute(COCOON_PASS_THROUGH);
            }
            return bl;
        }
        boolean bl = processor.process(env);
        Object var13_16 = null;
        env.setURI(oldPrefix, oldURI);
        if (oldPassThrough != null) {
            env.setAttribute(COCOON_PASS_THROUGH, oldPassThrough);
        } else {
            env.removeAttribute(COCOON_PASS_THROUGH);
        }
        return bl;
    }

    private synchronized TreeProcessor getProcessor(String source, String prefix) throws Exception {
        TreeProcessor processor = (TreeProcessor)this.processors.get(source);
        if (processor == null) {
            String actualSource = source.charAt(source.length() - 1) == '/' ? source + "sitemap.xmap" : source;
            processor = this.parentProcessor.createChildProcessor(actualSource, this.checkReload, prefix);
            this.processors.put(source, processor);
        }
        return processor;
    }

    public void dispose() {
        Iterator i = this.processors.values().iterator();
        while (i.hasNext()) {
            ((TreeProcessor)i.next()).dispose();
        }
        this.processors.clear();
    }
}

