/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.Map;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ParameterizableProcessingNode;
import org.apache.cocoon.components.treeprocessor.SimpleSelectorProcessingNode;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.matching.Matcher;
import org.apache.cocoon.matching.PreparableMatcher;
import org.apache.cocoon.sitemap.PatternException;

public class PreparableMatchNode
extends SimpleSelectorProcessingNode
implements ParameterizableProcessingNode,
Initializable {
    private String pattern;
    private String name;
    private Object preparedPattern;
    private Map parameters;

    public PreparableMatchNode(String type, String pattern, String name) {
        super(Matcher.ROLE + "Selector", type);
        this.pattern = pattern;
        this.name = name;
    }

    public void setParameters(Map parameterMap) {
        this.parameters = parameterMap;
    }

    public void initialize() throws Exception {
        PreparableMatcher matcher = (PreparableMatcher)this.getComponent();
        try {
            this.preparedPattern = matcher.preparePattern(this.pattern);
        }
        catch (PatternException pe) {
            String msg = "Invalid pattern '" + this.pattern + "' for matcher at " + this.getLocation();
            throw new ConfigurationException(msg, (Throwable)((Object)pe));
        }
        finally {
            this.releaseComponent(matcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        super.invoke(env, context);
        Map objectModel = env.getObjectModel();
        Parameters resolvedParams = VariableResolver.buildParameters(this.parameters, context, objectModel);
        Map result = null;
        PreparableMatcher matcher = (PreparableMatcher)this.getComponent();
        try {
            result = matcher.preparedMatch(this.preparedPattern, objectModel, resolvedParams);
        }
        finally {
            this.releaseComponent(matcher);
        }
        if (result != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Matcher '" + this.componentName + "' matched prepared pattern '" + this.pattern + "' at " + this.getLocation());
            }
            return this.invokeNodes(this.children, env, context, this.name, result);
        }
        return false;
    }
}

