/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.Collection;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.LinkedProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.sitemap.SerializeNode;
import org.apache.cocoon.components.treeprocessor.sitemap.SitemapLanguage;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolverFactory;
import org.apache.cocoon.serialization.Serializer;

public class SerializeNodeBuilder
extends AbstractProcessingNodeBuilder
implements LinkedProcessingNodeBuilder {
    private SerializeNode node;
    private Collection views;
    private Map pipelineHints;

    protected boolean hasParameters() {
        return true;
    }

    public ProcessingNode buildNode(Configuration config) throws Exception {
        String type = this.treeBuilder.getTypeForStatement(config, Serializer.ROLE);
        SitemapLanguage sitemapBuilder = (SitemapLanguage)this.treeBuilder;
        String mimeType = config.getAttribute("mime-type", null);
        if (mimeType == null) {
            mimeType = sitemapBuilder.getMimeType(Serializer.ROLE, type);
        }
        this.views = sitemapBuilder.getViewsForStatement(Serializer.ROLE, type, config);
        this.pipelineHints = sitemapBuilder.getHintsForStatement(Serializer.ROLE, type, config);
        this.node = new SerializeNode(type, VariableResolverFactory.getResolver(config.getAttribute("src", null), this.manager), VariableResolverFactory.getResolver(mimeType, this.manager), config.getAttributeAsInteger("status-code", -1));
        this.node.setPipelineHints(this.pipelineHints);
        return this.treeBuilder.setupNode(this.node, config);
    }

    public void linkNode() throws Exception {
        this.node.setViews(((SitemapLanguage)this.treeBuilder).getViewNodes(this.views));
    }
}

