/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.container.CocoonServiceManager;
import org.apache.cocoon.components.treeprocessor.CategoryNode;
import org.apache.cocoon.components.treeprocessor.CategoryNodeBuilder;
import org.apache.cocoon.components.treeprocessor.DefaultTreeBuilder;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.internal.EnvironmentHelper;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.serialization.Serializer;
import org.apache.cocoon.sitemap.PatternException;
import org.apache.cocoon.util.StringUtils;
import org.apache.regexp.RE;

public class SitemapLanguage
extends DefaultTreeBuilder {
    private static final String COMMA_SPLIT_REGEXP = "[\\s]*,[\\s]*";
    private static final String EQUALS_SPLIT_REGEXP = "[\\s]*=[\\s]*";
    private Map labelViews = new HashMap();
    private CategoryNode viewsNode;
    private boolean isBuildingView = false;
    private boolean isBuildingErrorHandler = false;
    public static final String FIRST_POS_LABEL = "!first!";
    public static final String LAST_POS_LABEL = "!last!";

    protected ServiceManager createServiceManager(Context context, Configuration tree) throws Exception {
        Configuration config = tree.getChild("components", false);
        if (config == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Sitemap has no components definition at " + tree.getLocation());
            }
            config = new DefaultConfiguration("", "");
        }
        CocoonServiceManager newManager = new CocoonServiceManager(this.parentProcessorManager);
        newManager.enableLogging(this.getLogger());
        newManager.contextualize(context);
        newManager.configure(config);
        newManager.initialize();
        return newManager;
    }

    protected Context createContext(Configuration tree) throws Exception {
        DefaultContext newContext = new DefaultContext(super.createContext(tree));
        Environment env = EnvironmentHelper.getCurrentEnvironment();
        newContext.put((Object)"env-uri", (Object)env.getURI());
        newContext.put((Object)"env-prefix", (Object)env.getURIPrefix());
        newContext.put((Object)"env-helper", (Object)this.getProcessor().getWrappingProcessor().getEnvironmentHelper());
        return newContext;
    }

    public void recycle() {
        super.recycle();
        this.labelViews.clear();
        this.viewsNode = null;
        this.isBuildingView = false;
        this.isBuildingErrorHandler = false;
    }

    public void setBuildingView(boolean building) {
        this.isBuildingView = building;
    }

    public boolean isBuildingView() {
        return this.isBuildingView;
    }

    public void setBuildingErrorHandler(boolean building) {
        this.isBuildingErrorHandler = building;
    }

    public boolean isBuildingErrorHandler() {
        return this.isBuildingErrorHandler;
    }

    public void addViewForLabel(String label, String view) {
        HashSet<String> views;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("views:addViewForLabel(" + label + ", " + view + ")");
        }
        if ((views = (HashSet<String>)this.labelViews.get(label)) == null) {
            views = new HashSet<String>();
            this.labelViews.put(label, views);
        }
        views.add(view);
    }

    public Collection getViewsForStatement(String role, String hint, Configuration statement) throws Exception {
        String[] compLabels;
        String statementLabels = statement.getAttribute("label", null);
        if (this.isBuildingView) {
            if (statementLabels != null) {
                String msg = "Cannot put a 'label' attribute inside view definition at " + statement.getLocation();
                throw new ConfigurationException(msg);
            }
            return null;
        }
        HashSet<String> views = null;
        HashSet<String> labels = new HashSet<String>();
        if (role != null && role.length() > 0 && (compLabels = this.itsComponentInfo.getLabels(role, hint)) != null) {
            for (int i = 0; i < compLabels.length; ++i) {
                labels.add(compLabels[i]);
            }
        }
        if (statementLabels != null) {
            labels.addAll(SitemapLanguage.splitLabels(statementLabels));
        }
        if (Generator.ROLE.equals(role)) {
            labels.add(FIRST_POS_LABEL);
        } else if (Serializer.ROLE.equals(role)) {
            labels.add(LAST_POS_LABEL);
        }
        views = new HashSet<String>();
        Iterator labelIter = labels.iterator();
        while (labelIter.hasNext()) {
            Collection coll = (Collection)this.labelViews.get(labelIter.next());
            if (coll == null) continue;
            Iterator viewIter = coll.iterator();
            while (viewIter.hasNext()) {
                String viewName = (String)viewIter.next();
                views.add(viewName);
            }
        }
        if (views.size() == 0) {
            views = null;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(statement.getName() + " has no views at " + statement.getLocation());
            }
        } else if (this.getLogger().isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(statement.getName() + " will match views [");
            Iterator iter = views.iterator();
            while (iter.hasNext()) {
                buf.append(iter.next()).append(" ");
            }
            buf.append("] at ").append(statement.getLocation());
            this.getLogger().debug(buf.toString());
        }
        return views;
    }

    protected void linkNodes() throws Exception {
        this.viewsNode = CategoryNodeBuilder.getCategoryNode(this, "views");
        super.linkNodes();
    }

    public Map getViewNodes(Collection viewNames) throws Exception {
        if (viewNames == null || viewNames.size() == 0) {
            return null;
        }
        if (this.viewsNode == null) {
            return null;
        }
        HashMap<String, ProcessingNode> result = new HashMap<String, ProcessingNode>();
        Iterator iter = viewNames.iterator();
        while (iter.hasNext()) {
            String viewName = (String)iter.next();
            result.put(viewName, this.viewsNode.getNodeByName(viewName));
        }
        return result;
    }

    public Map getHintsForStatement(String role, String hint, Configuration statement) throws Exception {
        String statementHintParams = statement.getAttribute("pipeline-hints", null);
        String componentHintParams = null;
        String hintParams = null;
        componentHintParams = this.itsComponentInfo.getPipelineHint(role, hint);
        if (componentHintParams != null) {
            hintParams = componentHintParams;
            if (statementHintParams != null) {
                hintParams = hintParams + "," + statementHintParams;
            }
        } else {
            hintParams = statementHintParams;
        }
        if (hintParams == null) {
            return null;
        }
        HashMap<VariableResolver, VariableResolver> params = new HashMap<VariableResolver, VariableResolver>();
        RE commaSplit = new RE(COMMA_SPLIT_REGEXP);
        RE equalsSplit = new RE(EQUALS_SPLIT_REGEXP);
        String[] expressions = commaSplit.split(hintParams.trim());
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("pipeline-hints: (aggregate-hint) " + hintParams);
        }
        for (int i = 0; i < expressions.length; ++i) {
            String[] nameValuePair = equalsSplit.split(expressions[i]);
            try {
                if (nameValuePair.length < 2) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("pipeline-hints: (name) " + nameValuePair[0] + "\npipeline-hints: (value) [implicit] true");
                    }
                    params.put(this.resolve(nameValuePair[0]), this.resolve("true"));
                    continue;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("pipeline-hints: (name) " + nameValuePair[0] + "\npipeline-hints: (value) " + nameValuePair[1]);
                }
                params.put(this.resolve(nameValuePair[0]), this.resolve(nameValuePair[1]));
                continue;
            }
            catch (PatternException pe) {
                String msg = "Invalid pattern '" + hintParams + "' at " + statement.getLocation();
                this.getLogger().error(msg, (Throwable)((Object)pe));
                throw new ConfigurationException(msg, (Throwable)((Object)pe));
            }
        }
        return params;
    }

    public String getMimeType(String role, String hint) {
        return this.itsComponentInfo.getMimeType(role, hint);
    }

    private static final Collection splitLabels(String labels) {
        if (labels == null) {
            return Collections.EMPTY_SET;
        }
        return Arrays.asList(StringUtils.split(labels, ", \t\n\r"));
    }
}

