/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container;

import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.thread.SingleThreaded;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.ServiceInfo;
import org.apache.cocoon.core.container.AbstractFactoryHandler;
import org.apache.cocoon.core.container.ComponentEnvironment;
import org.apache.cocoon.core.container.ComponentFactory;
import org.apache.cocoon.core.container.ComponentHandler;
import org.apache.cocoon.core.container.DefaultServiceSelector;
import org.apache.cocoon.core.container.PoolableComponentHandler;
import org.apache.cocoon.core.container.SingleThreadedComponentHandler;
import org.apache.cocoon.core.container.StandaloneServiceSelector;
import org.apache.cocoon.core.container.ThreadSafeComponentHandler;

public abstract class AbstractComponentHandler
implements ComponentHandler {
    private final Object referenceSemaphore = new Object();
    private int references = 0;
    protected final Logger logger;
    protected boolean disposed = false;
    private boolean initialized = false;
    private ServiceInfo info;

    public static ComponentHandler getComponentHandler(String role, ComponentEnvironment componentEnv, ServiceInfo info) throws Exception {
        Class componentClass;
        try {
            componentClass = componentEnv.loadClass(info.getServiceClassName());
        }
        catch (ClassNotFoundException cnfe) {
            throw new ConfigurationException("Cannot find class " + info.getServiceClassName() + " for component at " + info.getConfiguration().getLocation(), (Throwable)cnfe);
        }
        int numInterfaces = 0;
        if (Composable.class.isAssignableFrom(componentClass)) {
            throw new Exception("Interface Composable is not supported anymore. Please change class " + componentClass.getName() + " to use Serviceable instead.");
        }
        if (SingleThreaded.class.isAssignableFrom(componentClass)) {
            ++numInterfaces;
            info.setModel(0);
        }
        if (ThreadSafe.class.isAssignableFrom(componentClass)) {
            ++numInterfaces;
            info.setModel(1);
        }
        if (Poolable.class.isAssignableFrom(componentClass)) {
            ++numInterfaces;
            info.setModel(2);
        }
        if (numInterfaces > 1) {
            throw new Exception("[CONFLICT] More than one lifecycle interface in " + componentClass.getName() + "  May implement no more than one of " + "SingleThreaded, ThreadSafe, or Poolable");
        }
        if (numInterfaces == 0) {
            info.fill(info.getConfiguration());
        }
        if (DefaultServiceSelector.class.isAssignableFrom(componentClass)) {
            DefaultServiceSelector.Factory factory = new DefaultServiceSelector.Factory(componentEnv, info, role);
            ThreadSafeComponentHandler handler = new ThreadSafeComponentHandler(info, componentEnv.logger, factory);
            handler.initialize();
            return handler;
        }
        ComponentFactory factory = StandaloneServiceSelector.class.isAssignableFrom(componentClass) ? new StandaloneServiceSelector.Factory(componentEnv, info, role) : new ComponentFactory(componentEnv, info);
        AbstractFactoryHandler handler = info.getModel() == 2 ? new PoolableComponentHandler(info, componentEnv.logger, factory, info.getConfiguration()) : (info.getModel() == 1 ? new ThreadSafeComponentHandler(info, componentEnv.logger, factory) : new SingleThreadedComponentHandler(info, componentEnv.logger, factory));
        return handler;
    }

    public AbstractComponentHandler(ServiceInfo info, Logger logger) {
        this.logger = logger;
        this.info = info;
    }

    public ServiceInfo getInfo() {
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object get() throws Exception {
        this.initialize();
        if (this.disposed) {
            throw new IllegalStateException("You cannot get a component from a disposed handler.");
        }
        Object component = this.doGet();
        Object object = this.referenceSemaphore;
        synchronized (object) {
            ++this.references;
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(Object component) throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("You cannot put a component to an uninitialized handler.");
        }
        Object object = this.referenceSemaphore;
        synchronized (object) {
            --this.references;
        }
        try {
            this.doPut(component);
        }
        catch (Throwable t) {
            this.logger.error("Exception during putting back a component.", t);
        }
    }

    protected abstract Object doGet() throws Exception;

    protected abstract void doPut(Object var1) throws Exception;

    public boolean isSingleton() {
        return false;
    }

    public final boolean canBeDisposed() {
        return this.references == 0;
    }

    public void dispose() {
        this.disposed = true;
    }

    public final void initialize() throws Exception {
        if (this.initialized) {
            return;
        }
        this.doInitialize();
        this.initialized = true;
    }

    protected abstract void doInitialize() throws Exception;

    public static ComponentHandler getComponentHandler(Class clazz, Logger logger, Context context, ServiceManager manager, Configuration config) throws Exception {
        ComponentEnvironment env = new ComponentEnvironment(clazz.getClassLoader(), logger, null, null, context, manager);
        ServiceInfo info = new ServiceInfo();
        info.setServiceClassName(clazz.getName());
        info.setConfiguration(config);
        return AbstractComponentHandler.getComponentHandler(null, env, info);
    }
}

