/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.ServiceInfo;
import org.apache.cocoon.core.container.AbstractComponentHandler;
import org.apache.cocoon.core.container.ComponentEnvironment;
import org.apache.cocoon.core.container.ComponentHandler;
import org.apache.cocoon.core.container.DefaultServiceSelector;
import org.apache.cocoon.core.container.RoleManager;

public abstract class AbstractServiceManager
extends AbstractLogEnabled
implements Contextualizable,
ThreadSafe,
Disposable,
Initializable {
    protected Context context;
    protected final Map componentMapping = Collections.synchronizedMap(new HashMap());
    protected final Map componentHandlers = Collections.synchronizedMap(new HashMap());
    protected boolean disposed;
    protected boolean initialized;
    protected RoleManager roleManager;
    protected LoggerManager loggerManager;
    protected ComponentEnvironment componentEnv;

    public void contextualize(Context context) {
        this.context = context;
    }

    public void setRoleManager(RoleManager roles) {
        this.roleManager = roles;
    }

    public void setLoggerManager(LoggerManager manager) {
        this.loggerManager = manager;
    }

    protected ComponentHandler getComponentHandler(String role, Class componentClass, Configuration configuration, ServiceManager serviceManager) throws Exception {
        if (this.componentEnv == null) {
            this.componentEnv = new ComponentEnvironment(null, this.getLogger(), this.roleManager, this.loggerManager, this.context, serviceManager);
        }
        ServiceInfo info = new ServiceInfo();
        info.setConfiguration(configuration);
        info.setServiceClassName(componentClass.getName());
        return AbstractComponentHandler.getComponentHandler(role, this.componentEnv, info);
    }

    protected void addComponent(String className, String role, Configuration configuration) throws ConfigurationException {
        if ("org.apache.cocoon.components.ExtendedComponentSelector".equals(className)) {
            className = DefaultServiceSelector.class.getName();
        }
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Adding component (" + role + " = " + className + ")");
            }
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(className);
            this.addComponent(role, clazz, configuration);
        }
        catch (ClassNotFoundException cnfe) {
            String message = "Could not get class (" + className + ") for role " + role + " at " + configuration.getLocation();
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error(message, (Throwable)cnfe);
            }
            throw new ConfigurationException(message, (Throwable)cnfe);
        }
        catch (ServiceException ce) {
            String message = "Cannot setup class " + className + " for role " + role + " at " + configuration.getLocation();
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error(message, (Throwable)ce);
            }
            throw new ConfigurationException(message, (Throwable)ce);
        }
        catch (Exception e) {
            String message = "Unexpected exception when setting up role " + role + " at " + configuration.getLocation();
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error(message, (Throwable)e);
            }
            throw new ConfigurationException(message, (Throwable)e);
        }
    }

    protected abstract void addComponent(String var1, Class var2, Configuration var3) throws ServiceException;

    public void dispose() {
        this.disposed = true;
    }

    public void initialize() throws Exception {
        this.initialized = true;
    }
}

