/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container;

import java.lang.reflect.Method;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ServiceInfo;
import org.apache.cocoon.core.container.ComponentEnvironment;

public class ComponentFactory {
    protected final ServiceInfo serviceInfo;
    protected final ComponentEnvironment environment;
    protected final Logger componentLogger;
    protected Parameters parameters;
    protected final Class serviceClass;
    protected final Method initMethod;
    protected final Method destroyMethod;
    protected final Method poolInMethod;
    protected final Method poolOutMethod;

    public ComponentFactory(ComponentEnvironment environment, ServiceInfo info) throws Exception {
        String category;
        this.environment = environment;
        this.serviceInfo = info;
        Logger actualLogger = this.environment.logger;
        if (this.environment.loggerManager != null && this.serviceInfo.getConfiguration() != null && (category = this.serviceInfo.getConfiguration().getAttribute("logger", null)) != null) {
            actualLogger = this.environment.loggerManager.getLoggerForCategory(category);
        }
        this.componentLogger = actualLogger;
        this.serviceClass = this.environment.loadClass(this.serviceInfo.getServiceClassName());
        this.destroyMethod = this.serviceInfo.getDestroyMethodName() != null ? this.serviceClass.getMethod(this.serviceInfo.getDestroyMethodName(), null) : null;
        this.initMethod = this.serviceInfo.getInitMethodName() != null ? this.serviceClass.getMethod(this.serviceInfo.getInitMethodName(), null) : null;
        this.poolInMethod = this.serviceInfo.getPoolInMethodName() != null ? this.serviceClass.getMethod(this.serviceInfo.getPoolInMethodName(), null) : null;
        this.poolOutMethod = this.serviceInfo.getPoolOutMethodName() != null ? this.serviceClass.getMethod(this.serviceInfo.getPoolOutMethodName(), null) : null;
    }

    public final Object newInstance() throws Exception {
        Object component = this.serviceClass.newInstance();
        this.setupInstance(component);
        return component;
    }

    protected void setupInstance(Object component) throws Exception {
        if (this.environment.logger.isDebugEnabled()) {
            this.environment.logger.debug("ComponentFactory creating new instance of " + this.serviceClass.getName() + ".");
        }
        ContainerUtil.enableLogging((Object)component, (Logger)this.componentLogger);
        ContainerUtil.contextualize((Object)component, (Context)this.environment.context);
        ContainerUtil.service((Object)component, (ServiceManager)this.environment.serviceManager);
        ContainerUtil.configure((Object)component, (Configuration)this.serviceInfo.getConfiguration());
        if (component instanceof Parameterizable) {
            if (this.parameters == null) {
                this.parameters = Parameters.fromConfiguration((Configuration)this.serviceInfo.getConfiguration());
            }
            ContainerUtil.parameterize((Object)component, (Parameters)this.parameters);
        }
        ContainerUtil.initialize((Object)component);
        if (this.initMethod != null) {
            this.initMethod.invoke(component, null);
        }
        ContainerUtil.start((Object)component);
    }

    public Class getCreatedClass() {
        return this.serviceClass;
    }

    public void decommission(Object component) throws Exception {
        if (this.environment.logger.isDebugEnabled()) {
            this.environment.logger.debug("ComponentFactory decommissioning instance of " + this.serviceClass.getName() + ".");
        }
        ContainerUtil.stop((Object)component);
        ContainerUtil.dispose((Object)component);
        if (this.destroyMethod != null) {
            this.destroyMethod.invoke(component, null);
        }
    }

    public void exitingPool(Object component) throws Exception {
        if (this.poolOutMethod != null) {
            this.poolOutMethod.invoke(component, null);
        }
    }

    public void enteringPool(Object component) throws Exception {
        if (component instanceof Recyclable) {
            ((Recyclable)component).recycle();
        }
        if (this.poolInMethod != null) {
            this.poolInMethod.invoke(component, null);
        }
    }
}

