/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.cocoon.core.container.util.PropertyHelper;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class ConfigurationBuilder
extends DefaultHandler
implements ErrorHandler {
    private XMLReader parser;
    private static final int EXPECTED_DEPTH = 4;
    private final ArrayList elements = new ArrayList(4);
    private final ArrayList prefixes = new ArrayList(4);
    private final ArrayList values = new ArrayList(4);
    private final BitSet preserveSpace = new BitSet();
    private Configuration configuration;
    private Locator locator;
    private final NamespaceSupport namespaceSupport = new NamespaceSupport();

    public ConfigurationBuilder() {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            this.parser = saxParser.getXMLReader();
            this.parser.setContentHandler(this);
            this.parser.setErrorHandler(this);
        }
        catch (Exception se) {
            throw new Error("Unable to setup SAX parser" + se);
        }
    }

    public Configuration build(InputStream inputStream) throws SAXException, IOException, ConfigurationException {
        return this.build(new InputSource(inputStream));
    }

    public Configuration build(InputStream inputStream, String systemId) throws SAXException, IOException, ConfigurationException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(systemId);
        return this.build(inputSource);
    }

    public Configuration build(String uri) throws SAXException, IOException, ConfigurationException {
        return this.build(new InputSource(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration build(InputSource input) throws SAXException, IOException, ConfigurationException {
        ConfigurationBuilder configurationBuilder = this;
        synchronized (configurationBuilder) {
            this.clear();
            this.parser.parse(input);
            return this.configuration;
        }
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.parser.setEntityResolver(resolver);
    }

    protected void clear() {
        this.elements.clear();
        Iterator i = this.prefixes.iterator();
        while (i.hasNext()) {
            ((ArrayList)i.next()).clear();
        }
        this.prefixes.clear();
        this.values.clear();
        this.locator = null;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        this.namespaceSupport.reset();
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.namespaceSupport.reset();
    }

    public void characters(char[] ch, int start, int end) throws SAXException {
        int depth = this.values.size() - 1;
        StringBuffer valueBuffer = (StringBuffer)this.values.get(depth);
        valueBuffer.append(ch, start, end);
    }

    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        int depth = this.elements.size() - 1;
        DefaultConfiguration finishedConfiguration = (DefaultConfiguration)this.elements.remove(depth);
        String accumulatedValue = ((StringBuffer)this.values.remove(depth)).toString();
        ArrayList prefixes = (ArrayList)this.prefixes.remove(depth);
        Iterator i = prefixes.iterator();
        while (i.hasNext()) {
            this.endPrefixMapping((String)i.next());
        }
        prefixes.clear();
        if (finishedConfiguration.getChildren().length == 0) {
            Object finishedValue = this.preserveSpace.get(depth) ? accumulatedValue : (accumulatedValue.length() == 0 ? null : accumulatedValue.trim());
            finishedConfiguration.setValue(PropertyHelper.replace((String)finishedValue));
        } else {
            String trimmedValue = accumulatedValue.trim();
            if (trimmedValue.length() > 0) {
                throw new SAXException("Not allowed to define mixed content in the element " + finishedConfiguration.getName() + " at " + finishedConfiguration.getLocation());
            }
        }
        if (depth == 0) {
            this.configuration = finishedConfiguration;
        }
        this.namespaceSupport.popContext();
    }

    protected DefaultConfiguration createConfiguration(String localName, String namespaceURI, String location) {
        String prefix = this.namespaceSupport.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = "";
        }
        return new DefaultConfiguration(localName, location, namespaceURI, prefix);
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes attributes) throws SAXException {
        this.namespaceSupport.pushContext();
        DefaultConfiguration configuration = this.createConfiguration(localName, namespaceURI, this.getLocationString());
        int depth = this.elements.size();
        boolean preserveSpace = false;
        if (depth > 0) {
            DefaultConfiguration parent = (DefaultConfiguration)this.elements.get(depth - 1);
            parent.addChild((Configuration)configuration);
            preserveSpace = this.preserveSpace.get(depth - 1);
        }
        this.elements.add(configuration);
        this.values.add(new StringBuffer());
        ArrayList<String> prefixes = new ArrayList<String>();
        AttributesImpl componentAttr = new AttributesImpl();
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (attributes.getQName(i).startsWith("xmlns")) {
                prefixes.add(attributes.getLocalName(i));
                this.startPrefixMapping(attributes.getLocalName(i), attributes.getValue(i));
                continue;
            }
            if (attributes.getQName(i).equals("xml:space")) {
                preserveSpace = attributes.getValue(i).equals("preserve");
                continue;
            }
            componentAttr.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
        }
        if (preserveSpace) {
            this.preserveSpace.set(depth);
        } else {
            this.preserveSpace.clear(depth);
        }
        this.prefixes.add(prefixes);
        int attributesSize = componentAttr.getLength();
        for (int i = 0; i < attributesSize; ++i) {
            String name = componentAttr.getQName(i);
            String value = componentAttr.getValue(i);
            configuration.setAttribute(name, PropertyHelper.replace(value));
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void warning(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    private String getLocationString() {
        if (this.locator == null) {
            return "Unknown";
        }
        int columnNumber = this.locator.getColumnNumber();
        return this.locator.getSystemId() + ":" + this.locator.getLineNumber() + (columnNumber >= 0 ? ":" + columnNumber : "");
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaceSupport.declarePrefix(prefix, uri);
        super.startPrefixMapping(prefix, uri);
    }
}

