/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.ServiceInfo;
import org.apache.cocoon.core.container.AbstractComponentHandler;
import org.apache.cocoon.core.container.AliasComponentHandler;
import org.apache.cocoon.core.container.ComponentEnvironment;
import org.apache.cocoon.core.container.ComponentHandler;
import org.apache.cocoon.core.container.ConfigurationBuilder;
import org.apache.cocoon.core.container.DefaultServiceSelector;
import org.apache.cocoon.core.container.InstanceComponentHandler;
import org.apache.cocoon.core.container.LazyHandler;
import org.apache.cocoon.core.container.RoleManager;
import org.apache.cocoon.core.source.SimpleSourceResolver;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.TraversableSource;

public class CoreServiceManager
extends AbstractLogEnabled
implements Contextualizable,
ThreadSafe,
Disposable,
Initializable,
ServiceManager,
Configurable {
    public static final Configuration EMPTY_CONFIGURATION = new DefaultConfiguration("-", "unknown location");
    protected Context context;
    protected final Map componentMapping = Collections.synchronizedMap(new HashMap());
    protected final Map componentHandlers = Collections.synchronizedMap(new HashMap());
    protected boolean disposed;
    protected boolean initialized;
    protected RoleManager roleManager;
    protected LoggerManager loggerManager;
    private ComponentEnvironment componentEnv;
    private boolean lazyMode = Boolean.getBoolean("org.apache.cocoon.core.LazyMode");
    protected String location;
    protected ServiceManager parentManager;
    private SourceResolver cachedSourceResolver;

    public CoreServiceManager(ServiceManager parent) {
        this.parentManager = parent;
        RoleManager parentRoleManager = null;
        if (parent instanceof CoreServiceManager) {
            parentRoleManager = ((CoreServiceManager)parent).roleManager;
            this.loggerManager = ((CoreServiceManager)parent).loggerManager;
        }
        this.roleManager = new RoleManager(parentRoleManager);
    }

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        this.roleManager.enableLogging(logger);
        String msg = "Lazy mode: " + this.lazyMode;
        logger.debug(msg);
        System.out.println(msg);
    }

    public void contextualize(Context context) {
        this.context = context;
    }

    public void setLoggerManager(LoggerManager manager) {
        this.loggerManager = manager;
    }

    public void setRoleManager(RoleManager rm) {
        if (rm != null) {
            this.roleManager = new RoleManager(rm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Configuration configuration) throws ConfigurationException {
        String currentURI;
        this.componentEnv = new ComponentEnvironment(null, this.getLogger(), this.roleManager, this.loggerManager, this.context, this);
        this.location = configuration.getLocation();
        int pos = this.location.lastIndexOf(58);
        if (pos == -1) {
            currentURI = "context://";
        } else {
            pos = this.location.lastIndexOf(58, pos);
            currentURI = this.location.substring(0, pos - 1);
        }
        try {
            this.parseConfiguration(configuration, currentURI, new HashSet());
        }
        finally {
            this.releaseCachedSourceResolver();
        }
    }

    public void initialize() throws Exception {
        this.initialized = true;
        ComponentHandler[] handlers = this.componentHandlers.values().toArray(new ComponentHandler[this.componentHandlers.size()]);
        for (int i = 0; i < handlers.length; ++i) {
            try {
                handlers[i].initialize();
                continue;
            }
            catch (Exception e) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Caught an exception trying to initialize the component handler.", (Throwable)e);
                }
                throw e;
            }
        }
    }

    public void dispose() {
        boolean forceDisposal = false;
        ArrayList disposed = new ArrayList();
        while (this.componentHandlers.size() > 0) {
            Iterator iterator = this.componentHandlers.keySet().iterator();
            while (iterator.hasNext()) {
                Object role = iterator.next();
                ComponentHandler handler = (ComponentHandler)this.componentHandlers.get(role);
                if (!forceDisposal && !handler.canBeDisposed()) continue;
                if (forceDisposal && this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("disposing of handler for unreleased component. role [" + role + "]");
                }
                handler.dispose();
                disposed.add(role);
            }
            if (disposed.size() > 0) {
                Iterator i = disposed.iterator();
                while (i.hasNext()) {
                    this.componentHandlers.remove(i.next());
                }
                disposed.clear();
                continue;
            }
            forceDisposal = true;
        }
        this.disposed = true;
    }

    public boolean hasService(String role) {
        if (!this.initialized || this.disposed) {
            return false;
        }
        boolean exists = this.componentHandlers.containsKey(role);
        if (!exists && null != this.parentManager) {
            exists = this.parentManager.hasService(role);
        }
        return exists;
    }

    public Object lookup(String role) throws ServiceException {
        if (!this.initialized && this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("Looking up component on an uninitialized CoreServiceManager [" + role + "]");
        }
        if (this.disposed) {
            throw new IllegalStateException("You cannot lookup components on a disposed CoreServiceManager");
        }
        if (role == null) {
            String message = "CoreServiceManager attempted to retrieve service with null role.";
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("CoreServiceManager attempted to retrieve service with null role.");
            }
            throw new ServiceException(role, "CoreServiceManager attempted to retrieve service with null role.");
        }
        ComponentHandler handler = (ComponentHandler)this.componentHandlers.get(role);
        if (handler == null) {
            block22: {
                if (this.parentManager != null) {
                    try {
                        return this.parentManager.lookup(role);
                    }
                    catch (Exception e) {
                        if (!this.getLogger().isWarnEnabled()) break block22;
                        String message = "ComponentLocator exception from parent SM during lookup.";
                        this.getLogger().warn("ComponentLocator exception from parent SM during lookup.", (Throwable)e);
                    }
                }
            }
            if (this.roleManager != null) {
                ServiceInfo info = this.roleManager.getDefaultServiceInfoForRole(role);
                if (info != null) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Could not find ComponentHandler, attempting to create one for role [" + role + "]");
                    }
                    try {
                        DefaultConfiguration configuration = new DefaultConfiguration("", "-");
                        handler = this.getComponentHandler(role, info.getServiceClassName(), (Configuration)configuration);
                        handler.initialize();
                    }
                    catch (ServiceException se) {
                        throw se;
                    }
                    catch (Exception e) {
                        String message = "Could not find component for role [" + role + "]";
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug(message, (Throwable)e);
                        }
                        throw new ServiceException(role, message, (Throwable)e);
                    }
                    this.componentHandlers.put(role, handler);
                }
            } else {
                this.getLogger().debug("Component requested without a RoleManager set.\nThat means setRoleManager() was not called during initialization.");
            }
        }
        if (handler == null) {
            String message = "Could not find component for role: [" + role + "]";
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(message);
            }
            throw new ServiceException(role, message);
        }
        Object component = null;
        try {
            component = handler.get();
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            String message = "Could not access the component for role [" + role + "]";
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(message, (Throwable)e);
            }
            throw new ServiceException(role, message, (Throwable)e);
        }
        this.initialize(role, component);
        this.componentMapping.put(component, handler);
        return component;
    }

    public void release(Object component) {
        if (null == component) {
            return;
        }
        ComponentHandler handler = (ComponentHandler)this.componentMapping.get(component);
        if (handler != null) {
            if (!handler.isSingleton()) {
                this.componentMapping.remove(component);
            }
            try {
                handler.put(component);
            }
            catch (Exception e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Error trying to release component.", (Throwable)e);
                }
            }
        } else if (this.parentManager != null) {
            this.parentManager.release(component);
        } else {
            this.getLogger().warn("Attempted to release a " + component.getClass().getName() + " but its handler could not be located.");
        }
    }

    public void addComponent(String role, String className, Configuration configuration) throws ConfigurationException {
        ComponentHandler handler;
        if (this.initialized) {
            throw new IllegalStateException("Cannot add components to an initialized CoreServiceManager.");
        }
        if ("org.apache.cocoon.components.ExtendedComponentSelector".equals(className)) {
            className = DefaultServiceSelector.class.getName();
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Adding component (" + role + " = " + className + ")");
        }
        if ((handler = (ComponentHandler)this.componentHandlers.get(role)) != null) {
            this.checkComponentOverride(role, className, configuration, handler);
        }
        try {
            handler = this.getComponentHandler(role, className, configuration);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Handler type = " + handler.getClass().getName());
            }
            this.componentHandlers.put(role, handler);
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not add component defined at " + configuration.getLocation(), (Throwable)e);
        }
    }

    public void addInstance(String role, Object instance) throws ServiceException {
        if (this.initialized) {
            throw new ServiceException(role, "Cannot add components to an initialized CoreServiceManager.");
        }
        ComponentHandler handler = (ComponentHandler)this.componentHandlers.get(role);
        if (handler != null) {
            ServiceInfo info = handler.getInfo();
            throw new ServiceException(role, "Component already defined at " + info.getLocation());
        }
        this.componentHandlers.put(role, new InstanceComponentHandler(this.getLogger(), instance));
    }

    public void addRoleAlias(String existingRole, String newRole) throws ServiceException {
        ComponentHandler handler = (ComponentHandler)this.componentHandlers.get(existingRole);
        if (handler == null) {
            CoreServiceManager current = this;
            while (handler == null && current.parentManager != null) {
                if (!(current.parentManager instanceof CoreServiceManager)) {
                    throw new ServiceException(newRole, "Cannot alias to components not managed by CoreServiceManager");
                }
                current = (CoreServiceManager)current.parentManager;
                handler = (ComponentHandler)current.componentHandlers.get(existingRole);
            }
        }
        if (handler == null) {
            throw new ServiceException(newRole, "Cannot alias non-existing role " + existingRole);
        }
        this.componentHandlers.put(newRole, new AliasComponentHandler(this.getLogger(), handler));
    }

    protected void initialize(String role, Object component) throws ServiceException {
    }

    private ComponentHandler getComponentHandler(String role, String className, Configuration configuration) throws Exception {
        ServiceInfo info = new ServiceInfo();
        info.setConfiguration(configuration);
        info.setServiceClassName(className);
        if (!this.lazyMode || configuration.getAttributeAsBoolean("preload", false) || role.endsWith("Selector")) {
            return AbstractComponentHandler.getComponentHandler(role, this.componentEnv, info);
        }
        return new LazyHandler(role, className, configuration, this.componentEnv);
    }

    private void parseConfiguration(Configuration configuration, String contextURI, Set loadedURIs) throws ConfigurationException {
        Configuration[] configurations = configuration.getChildren();
        for (int i = 0; i < configurations.length; ++i) {
            String name;
            Configuration componentConfig = configurations[i];
            String componentName = componentConfig.getName();
            if ("include".equals(componentName)) {
                this.handleInclude(contextURI, loadedURIs, componentConfig);
                continue;
            }
            String role = componentConfig.getAttribute("role", null);
            if (role == null && (role = this.roleManager.getRoleForName(componentName)) == null) {
                throw new ConfigurationException("Unknown component type '" + componentName + "' at " + componentConfig.getLocation());
            }
            String className = componentConfig.getAttribute("class", null);
            if (className == null) {
                ServiceInfo info = this.roleManager.getDefaultServiceInfoForRole(role);
                if (info == null) {
                    throw new ConfigurationException("Cannot find a class for role " + role + " at " + componentConfig.getLocation());
                }
                className = info.getServiceClassName();
            }
            if ((name = componentConfig.getAttribute("name", null)) != null) {
                role = role + "/" + name;
            }
            this.addComponent(role, className, componentConfig);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleInclude(String contextURI, Set loadedURIs, Configuration includeStatement) throws ConfigurationException {
        String includeURI = includeStatement.getAttribute("src", null);
        String directoryURI = null;
        if (includeURI == null) {
            directoryURI = includeStatement.getAttribute("dir", null);
        }
        if (includeURI == null && directoryURI == null) {
            throw new ConfigurationException("Include statement must either have a 'src' or 'dir' attribute, at " + includeStatement.getLocation());
        }
        this.setupSourceResolver();
        if (includeURI != null) {
            Source src;
            try {
                src = this.cachedSourceResolver.resolveURI(includeURI, contextURI, null);
            }
            catch (Exception e) {
                throw new ConfigurationException("Cannot load '" + includeURI + "' at " + includeStatement.getLocation(), (Throwable)e);
            }
            this.loadURI(src, loadedURIs, includeStatement);
            return;
        }
        Source directory = null;
        try {
            directory = this.cachedSourceResolver.resolveURI(directoryURI, contextURI, null);
            if (!(directory instanceof TraversableSource)) throw new ConfigurationException("Include.dir must point to a directory, '" + directory.getURI() + "' is not a directory.'");
            Iterator children = ((TraversableSource)directory).getChildren().iterator();
            while (children.hasNext()) {
                Source s = (Source)children.next();
                this.loadURI(s, loadedURIs, includeStatement);
            }
        }
        catch (IOException ioe) {
            try {
                throw new ConfigurationException("Unable to read configurations from " + directoryURI);
            }
            catch (Throwable throwable) {
                this.cachedSourceResolver.release(directory);
                throw throwable;
            }
        }
        this.cachedSourceResolver.release(directory);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadURI(Source src, Set loadedURIs, Configuration includeStatement) throws ConfigurationException {
        block8: {
            try {
                String uri = src.getURI();
                if (loadedURIs.contains(uri)) break block8;
                Configuration includeConfig = null;
                try {
                    ConfigurationBuilder builder = new ConfigurationBuilder();
                    includeConfig = builder.build(src.getInputStream(), uri);
                }
                catch (ConfigurationException ce) {
                    throw ce;
                }
                catch (Exception e) {
                    throw new ConfigurationException("Cannot load '" + uri + "' at " + includeStatement.getLocation(), (Throwable)e);
                }
                loadedURIs.add(uri);
                String includeKind = includeConfig.getName();
                if (includeKind.equals("components")) {
                    this.parseConfiguration(includeConfig, uri, loadedURIs);
                    break block8;
                }
                if (includeKind.equals("role-list")) {
                    this.roleManager.configure(includeConfig);
                    break block8;
                }
                throw new ConfigurationException("Unknow document '" + includeKind + "' included at " + includeStatement.getLocation());
            }
            finally {
                this.cachedSourceResolver.release(src);
            }
        }
    }

    private void setupSourceResolver() {
        if (this.cachedSourceResolver == null) {
            if (this.parentManager != null && this.parentManager.hasService(SourceResolver.ROLE)) {
                try {
                    this.cachedSourceResolver = (SourceResolver)this.parentManager.lookup(SourceResolver.ROLE);
                }
                catch (ServiceException se) {
                    throw new CascadingRuntimeException("Cannot get source resolver from parent, at " + this.location, (Throwable)se);
                }
            }
            SimpleSourceResolver simpleSR = new SimpleSourceResolver();
            simpleSR.enableLogging(this.getLogger());
            try {
                simpleSR.contextualize(this.context);
            }
            catch (ContextException ce) {
                throw new CascadingRuntimeException("Cannot setup source resolver, at " + this.location, (Throwable)ce);
            }
            this.cachedSourceResolver = simpleSR;
        }
    }

    private void releaseCachedSourceResolver() {
        if (this.cachedSourceResolver != null && this.parentManager != null && this.parentManager.hasService(SourceResolver.ROLE)) {
            this.parentManager.release((Object)this.cachedSourceResolver);
        }
        this.cachedSourceResolver = null;
    }

    private void checkComponentOverride(String role, String className, Configuration config, ComponentHandler existingHandler) throws ConfigurationException {
        Class clazz;
        ServiceInfo info = existingHandler.getInfo();
        if (!className.equals(info.getServiceClassName())) {
            throw new ConfigurationException("Role " + role + " redefined with a different class name, at " + config.getLocation());
        }
        try {
            clazz = this.componentEnv.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ConfigurationException("Cannot load class " + className + " for component at " + config.getLocation(), (Throwable)cnfe);
        }
        if (!DefaultServiceSelector.class.isAssignableFrom(clazz)) {
            throw new ConfigurationException("Component declared at " + info.getLocation() + " is redefined at " + config.getLocation());
        }
    }
}

