/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.ServiceInfo;
import org.apache.cocoon.core.container.ComponentEnvironment;
import org.apache.cocoon.core.container.ComponentFactory;
import org.apache.cocoon.core.container.CoreServiceManager;
import org.apache.cocoon.core.container.RoleManager;

public class DefaultServiceSelector
extends AbstractLogEnabled
implements ThreadSafe,
Serviceable,
Configurable,
ServiceSelector {
    public static final String DEFAULT_HINT = "$default$";
    private CoreServiceManager manager;
    private RoleManager roleManager;
    private String roleName;
    private String rolePrefix;

    public void service(ServiceManager manager) throws ServiceException {
        try {
            this.manager = (CoreServiceManager)manager;
        }
        catch (ClassCastException cce) {
            throw new ServiceException("DefaultServiceSelector", "A DefaultServiceSelector can only be hosted by a CoreServiceManager");
        }
    }

    public void setRole(String role) {
        this.roleName = role;
    }

    public void setRoleManager(RoleManager roles) {
        this.roleManager = roles;
    }

    public void configure(Configuration config) throws ConfigurationException {
        if (this.roleName == null) {
            throw new ConfigurationException("No role given for DefaultServiceSelector at " + config.getLocation());
        }
        this.rolePrefix = this.roleName.endsWith("Selector") ? this.roleName.substring(0, this.roleName.length() - 8) + "/" : this.roleName + "/";
        String compInstanceName = this.getComponentInstanceName();
        Configuration[] instances = config.getChildren();
        for (int i = 0; i < instances.length; ++i) {
            String className;
            ServiceInfo info;
            Configuration instance = instances[i];
            String key = instance.getAttribute("name");
            String classAttr = instance.getAttribute(this.getClassAttributeName(), null);
            if (compInstanceName == null) {
                if (classAttr == null) {
                    info = this.roleManager.getDefaultServiceInfoForKey(this.roleName, instance.getName());
                    className = info.getServiceClassName();
                } else {
                    className = classAttr;
                }
            } else if (compInstanceName.equals(instance.getName())) {
                className = classAttr == null ? null : classAttr;
            } else {
                info = this.roleManager.getDefaultServiceInfoForKey(this.roleName, instance.getName());
                className = info.getServiceClassName();
            }
            if (className == null) {
                String message = "Unable to determine class name for component named '" + key + "' at " + instance.getLocation();
                this.getLogger().error(message);
                throw new ConfigurationException(message);
            }
            this.manager.addComponent(this.rolePrefix + key, className, instance);
        }
        String defaultKey = config.getAttribute(this.getDefaultKeyAttributeName(), null);
        if (defaultKey != null) {
            try {
                this.manager.addRoleAlias(this.rolePrefix + defaultKey, this.rolePrefix + DEFAULT_HINT);
            }
            catch (ServiceException e) {
                throw new ConfigurationException("Cannot set default to " + defaultKey + " at " + config.getLocation(), (Throwable)e);
            }
        }
    }

    public Object select(Object hint) throws ServiceException {
        String key = hint == null ? DEFAULT_HINT : hint.toString();
        return this.manager.lookup(this.rolePrefix + key);
    }

    public boolean isSelectable(Object hint) {
        String key = hint == null ? DEFAULT_HINT : hint.toString();
        return key != null && this.manager.hasService(this.rolePrefix + key);
    }

    public void release(Object obj) {
        this.manager.release(obj);
    }

    protected String getComponentInstanceName() {
        return null;
    }

    protected String getClassAttributeName() {
        return "class";
    }

    protected String getDefaultKeyAttributeName() {
        return "default";
    }

    public static class Factory
    extends ComponentFactory {
        private final String role;

        public Factory(ComponentEnvironment env, ServiceInfo info, String role) throws Exception {
            super(env, info);
            this.role = role;
        }

        protected void setupInstance(Object object) throws Exception {
            DefaultServiceSelector component = (DefaultServiceSelector)((Object)object);
            ContainerUtil.enableLogging((Object)((Object)component), (Logger)this.environment.logger);
            ContainerUtil.contextualize((Object)((Object)component), (Context)this.environment.context);
            ContainerUtil.service((Object)((Object)component), (ServiceManager)this.environment.serviceManager);
            component.setRoleManager(this.environment.roleManager);
            component.setRole(this.role);
            ContainerUtil.configure((Object)((Object)component), (Configuration)this.serviceInfo.getConfiguration());
            ContainerUtil.initialize((Object)((Object)component));
            ContainerUtil.start((Object)((Object)component));
        }
    }
}

