/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container;

import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.cocoon.components.ServiceInfo;
import org.apache.cocoon.core.container.AbstractComponentHandler;
import org.apache.cocoon.core.container.ComponentEnvironment;
import org.apache.cocoon.core.container.ComponentHandler;

public class LazyHandler
implements ComponentHandler {
    private String role;
    private String className;
    private Configuration config;
    private ComponentEnvironment compEnv;
    private ComponentHandler delegate;

    public LazyHandler(String role, String className, Configuration configuration, ComponentEnvironment environment) {
        this.role = role;
        this.className = className;
        this.config = configuration;
        this.compEnv = environment;
    }

    private ComponentHandler getDelegate() throws Exception {
        if (this.delegate == null) {
            ServiceInfo info = new ServiceInfo();
            info.setConfiguration(this.config);
            info.setServiceClassName(this.className);
            this.delegate = AbstractComponentHandler.getComponentHandler(this.role, this.compEnv, info);
            this.delegate.initialize();
        }
        return this.delegate;
    }

    private ComponentHandler getDelegateRE() {
        try {
            return this.getDelegate();
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Cannot get delegate handler", (Throwable)e);
        }
    }

    public Object get() throws Exception {
        return this.getDelegate().get();
    }

    public void put(Object component) throws Exception {
        this.getDelegate().put(component);
    }

    public boolean isSingleton() {
        return this.getDelegateRE().isSingleton();
    }

    public boolean canBeDisposed() {
        if (this.delegate == null) {
            return true;
        }
        return this.getDelegateRE().canBeDisposed();
    }

    public void dispose() {
        if (this.delegate != null) {
            this.delegate.dispose();
        }
    }

    public void initialize() throws Exception {
    }

    public ServiceInfo getInfo() {
        if (this.delegate == null) {
            ServiceInfo info = new ServiceInfo();
            info.setServiceClassName(this.className);
            info.setConfiguration(this.config);
            return info;
        }
        return this.delegate.getInfo();
    }
}

