/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.components.ServiceInfo;
import org.apache.cocoon.core.container.AbstractFactoryHandler;
import org.apache.cocoon.core.container.ComponentFactory;

public class PoolableComponentHandler
extends AbstractFactoryHandler {
    public static final int DEFAULT_MAX_POOL_SIZE = 8;
    protected final Object semaphore = new Object();
    private final int max;
    private LinkedList ready;
    private int readySize;
    private int size;

    public PoolableComponentHandler(ServiceInfo info, Logger logger, ComponentFactory factory, Configuration config) throws Exception {
        super(info, logger, factory);
        int poolMax = config.getAttributeAsInteger("pool-max", 8);
        this.max = poolMax <= 0 ? Integer.MAX_VALUE : poolMax;
        this.ready = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        super.dispose();
        Object object = this.semaphore;
        synchronized (object) {
            Iterator iter = this.ready.iterator();
            while (iter.hasNext()) {
                Object poolable = iter.next();
                iter.remove();
                --this.readySize;
                this.permanentlyRemovePoolable(poolable);
            }
            if (this.size > 0 && this.logger.isDebugEnabled()) {
                this.logger.debug("There were " + this.size + " outstanding objects when the pool was disposed.");
            }
        }
    }

    protected void permanentlyRemovePoolable(Object poolable) {
        --this.size;
        this.decommission(poolable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doGet() throws Exception {
        Object poolable;
        Object object = this.semaphore;
        synchronized (object) {
            if (this.readySize > 0) {
                poolable = this.ready.removeLast();
                --this.readySize;
            } else {
                poolable = this.factory.newInstance();
                ++this.size;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Created a new " + poolable.getClass().getName() + " from the object factory.");
                }
            }
        }
        this.factory.exitingPool(poolable);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Got a " + poolable.getClass().getName() + " from the pool.");
        }
        return poolable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(Object poolable) {
        try {
            this.factory.enteringPool(poolable);
        }
        catch (Exception ignore) {
            this.logger.warn("Exception during putting component back into the pool.", (Throwable)ignore);
        }
        Object object = this.semaphore;
        synchronized (object) {
            if (this.size <= this.max) {
                if (this.disposed) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Put called for a " + poolable.getClass().getName() + " after the pool was disposed.");
                    }
                    this.permanentlyRemovePoolable(poolable);
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Put a " + poolable.getClass().getName() + " back into the pool.");
                    }
                    this.ready.addLast(poolable);
                    ++this.readySize;
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("No room to put a " + poolable.getClass().getName() + " back into the pool, so remove it.");
                }
                this.permanentlyRemovePoolable(poolable);
            }
        }
    }

    protected void doInitialize() {
    }
}

