/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.components.ServiceInfo;

public class RoleManager
extends AbstractLogEnabled
implements Configurable {
    private Map shorthands = new HashMap();
    private Map classNames = new HashMap();
    private Map keyClassNames = new HashMap();
    private final RoleManager parent;

    public RoleManager() {
        this.parent = null;
    }

    public RoleManager(RoleManager parent) {
        this.parent = parent;
    }

    public final String getRoleForName(String shorthandName) {
        String role = (String)this.shorthands.get(shorthandName);
        if (null == role && null != this.parent) {
            return this.parent.getRoleForName(shorthandName);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("looking up shorthand " + shorthandName + ", returning " + role);
        }
        return role;
    }

    public final ServiceInfo getDefaultServiceInfoForRole(String role) {
        ServiceInfo info = (ServiceInfo)this.classNames.get(role);
        if (info == null && this.parent != null) {
            return this.parent.getDefaultServiceInfoForRole(role);
        }
        return info;
    }

    public final ServiceInfo getDefaultServiceInfoForKey(String role, String shorthand) {
        ServiceInfo s;
        Map keyMap;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("looking up keymap for role " + role);
        }
        if (null == (keyMap = (Map)this.keyClassNames.get(role))) {
            if (null != this.parent) {
                return this.parent.getDefaultServiceInfoForKey(role, shorthand);
            }
            return null;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("looking up classname for key " + shorthand);
        }
        if ((s = (ServiceInfo)keyMap.get(shorthand)) == null && this.parent != null) {
            return this.parent.getDefaultServiceInfoForKey(role, shorthand);
        }
        return s;
    }

    public final void configure(Configuration configuration) throws ConfigurationException {
        boolean strictMode = "roles-list".equals(configuration.getName());
        Configuration[] roles = configuration.getChildren();
        for (int i = 0; i < roles.length; ++i) {
            Configuration[] keys;
            String previous;
            Configuration role = roles[i];
            if (!"role".equals(role.getName())) {
                if (!strictMode) continue;
                throw new ConfigurationException("Unexpected '" + role.getName() + "' element at " + role.getLocation());
            }
            String roleName = role.getAttribute("name");
            String shorthand = role.getAttribute("shorthand", null);
            String defaultClassName = role.getAttribute("default-class", null);
            if (shorthand != null && (previous = this.shorthands.put(shorthand, roleName)) != null && !previous.equals(roleName)) {
                throw new ConfigurationException("Shorthand '" + shorthand + "' already used for role " + previous + ": inconsistent declaration at " + role.getLocation());
            }
            if (defaultClassName != null) {
                ServiceInfo info = (ServiceInfo)this.classNames.get(roleName);
                if (info == null) {
                    info = new ServiceInfo();
                    info.setServiceClassName(defaultClassName);
                    info.fill(role);
                    this.classNames.put(roleName, info);
                } else if (!defaultClassName.equals(info.getServiceClassName())) {
                    throw new ConfigurationException("Invalid redeclaration: default class already set to " + info.getServiceClassName() + " for role " + roleName + " at " + role.getLocation());
                }
            }
            if ((keys = role.getChildren("hint")).length > 0) {
                HashMap<String, ServiceInfo> keyMap = (HashMap<String, ServiceInfo>)this.keyClassNames.get(roleName);
                if (keyMap == null) {
                    keyMap = new HashMap<String, ServiceInfo>();
                    this.keyClassNames.put(roleName, keyMap);
                }
                for (int j = 0; j < keys.length; ++j) {
                    Configuration key = keys[j];
                    String shortHand = key.getAttribute("shorthand").trim();
                    String className = key.getAttribute("class").trim();
                    ServiceInfo info = (ServiceInfo)keyMap.get(shortHand);
                    if (info == null) {
                        info = new ServiceInfo();
                        info.setServiceClassName(className);
                        info.fill(key);
                        keyMap.put(shortHand, info);
                        if (!this.getLogger().isDebugEnabled()) continue;
                        this.getLogger().debug("Adding key type " + shortHand + " associated with role " + roleName + " and class " + className);
                        continue;
                    }
                    if (className.equals(info.getServiceClassName())) continue;
                    throw new ConfigurationException("Invalid redeclaration: class already set to " + info.getServiceClassName() + " for hint " + shortHand + " at " + key.getLocation());
                }
            }
            if (!this.getLogger().isDebugEnabled()) continue;
            this.getLogger().debug("added Role " + roleName + " with shorthand " + shorthand + " for " + defaultClassName);
        }
    }
}

