/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ServiceInfo;
import org.apache.cocoon.core.container.AbstractServiceManager;
import org.apache.cocoon.core.container.CocoonServiceSelector;
import org.apache.cocoon.core.container.ComponentEnvironment;
import org.apache.cocoon.core.container.ComponentFactory;
import org.apache.cocoon.core.container.ComponentHandler;
import org.apache.cocoon.core.container.CoreServiceManager;

public class StandaloneServiceSelector
extends AbstractServiceManager
implements ServiceSelector,
Serviceable,
Configurable {
    protected ServiceManager serviceManager;
    protected CocoonServiceSelector parentSelector;
    protected ServiceManager parentLocator;
    protected String roleName;
    protected String defaultKey;

    public Object select(Object hint) throws ServiceException {
        String key = hint == null ? this.defaultKey : hint.toString();
        if (!this.initialized && this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("Selecting a component on an uninitialized service selector with key [" + key + "]");
        }
        if (this.disposed) {
            throw new IllegalStateException("You cannot select a component from a disposed service selector.");
        }
        ComponentHandler handler = (ComponentHandler)this.componentHandlers.get(key);
        if (null == handler) {
            if (this.parentSelector != null) {
                return this.parentSelector.select(key);
            }
            String message = this.roleName + ": service selector could not find the component for key [" + key + "]";
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(message);
            }
            throw new ServiceException(key, message);
        }
        Object component = null;
        try {
            component = handler.get();
        }
        catch (ServiceException ce) {
            throw ce;
        }
        catch (Exception e) {
            String message = this.roleName + ": service selector could not access the component for key [" + key + "]";
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(message, (Throwable)e);
            }
            throw new ServiceException(key, message, (Throwable)e);
        }
        if (null == component) {
            if (this.parentSelector != null) {
                component = this.parentSelector.select(key);
            } else {
                String message = this.roleName + ": service selector could not find the component for key [" + key + "]";
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(message);
                }
                throw new ServiceException(key, message);
            }
        }
        this.componentMapping.put(component, handler);
        return component;
    }

    public boolean isSelectable(Object hint) {
        String key = hint == null ? this.defaultKey : hint.toString();
        if (!this.initialized) {
            return false;
        }
        if (this.disposed) {
            return false;
        }
        boolean exists = false;
        try {
            ComponentHandler handler = (ComponentHandler)this.componentHandlers.get(key);
            exists = handler != null;
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (!exists && this.parentSelector != null) {
            exists = this.parentSelector.isSelectable(key);
        }
        return exists;
    }

    public void release(Object component) {
        block7: {
            if (null == component) {
                return;
            }
            if (this.parentSelector != null && this.parentSelector.canRelease(component)) {
                this.parentSelector.release(component);
            } else {
                ComponentHandler handler = (ComponentHandler)this.componentMapping.get(component);
                if (null == handler) {
                    this.getLogger().warn("Attempted to release a " + component.getClass().getName() + " but its handler could not be located.");
                    return;
                }
                if (!handler.isSingleton()) {
                    this.componentMapping.remove(component);
                }
                try {
                    handler.put(component);
                }
                catch (Exception e) {
                    if (!this.getLogger().isDebugEnabled()) break block7;
                    this.getLogger().debug("Error trying to release component", (Throwable)e);
                }
            }
        }
    }

    public void service(ServiceManager componentManager) throws ServiceException {
        this.serviceManager = componentManager;
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.roleName = this.getRoleName(config);
        this.defaultKey = config.getAttribute(this.getDefaultKeyAttributeName(), null);
        String compInstanceName = this.getComponentInstanceName();
        Configuration[] instances = config.getChildren();
        for (int i = 0; i < instances.length; ++i) {
            String className;
            ServiceInfo info;
            Configuration instance = instances[i];
            String key = instance.getAttribute("name").trim();
            String classAttr = instance.getAttribute(this.getClassAttributeName(), null);
            if (compInstanceName == null) {
                if (classAttr == null) {
                    info = this.roleManager.getDefaultServiceInfoForKey(this.roleName, instance.getName());
                    className = info.getServiceClassName();
                } else {
                    className = classAttr.trim();
                }
            } else if (compInstanceName.equals(instance.getName())) {
                className = classAttr == null ? null : classAttr.trim();
            } else {
                info = this.roleManager.getDefaultServiceInfoForKey(this.roleName, instance.getName());
                className = info.getServiceClassName();
            }
            if (className == null) {
                String message = "Unable to determine class name for component named '" + key + "' at " + instance.getLocation();
                this.getLogger().error(message);
                throw new ConfigurationException(message);
            }
            this.addComponent(className, key, instance);
        }
    }

    public void initialize() throws Exception {
        super.initialize();
        ArrayList keys = new ArrayList(this.componentHandlers.keySet());
        for (int i = 0; i < keys.size(); ++i) {
            Object key = keys.get(i);
            ComponentHandler handler = (ComponentHandler)this.componentHandlers.get(key);
            try {
                handler.initialize();
                continue;
            }
            catch (Exception e) {
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("Caught an exception trying to initialize of the component handler.", (Throwable)e);
            }
        }
    }

    public void dispose() {
        Iterator<Object> keys = this.componentHandlers.keySet().iterator();
        ArrayList keyList = new ArrayList();
        while (keys.hasNext()) {
            Object key = keys.next();
            ComponentHandler handler = (ComponentHandler)this.componentHandlers.get(key);
            handler.dispose();
            keyList.add(key);
        }
        keys = keyList.iterator();
        while (keys.hasNext()) {
            this.componentHandlers.remove(keys.next());
        }
        keyList.clear();
        if (this.parentLocator != null) {
            this.parentLocator.release((Object)this.parentSelector);
            this.parentLocator = null;
            this.parentSelector = null;
        }
        super.dispose();
    }

    public void addComponent(String key, Class component, Configuration configuration) throws ServiceException {
        if (this.initialized) {
            throw new ServiceException(key, "Cannot add components to an initialized service selector");
        }
        try {
            ComponentHandler handler = this.getComponentHandler(null, component, configuration, this.serviceManager);
            handler.initialize();
            this.componentHandlers.put(key, handler);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Adding " + component.getName() + " for key [" + key + "]");
            }
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            String message = "Could not set up component for key [ " + key + "]";
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error(message, (Throwable)e);
            }
            throw new ServiceException(key, message, (Throwable)e);
        }
    }

    protected String getComponentInstanceName() {
        return null;
    }

    protected String getClassAttributeName() {
        return "class";
    }

    protected String getDefaultKeyAttributeName() {
        return "default";
    }

    protected String getRoleName(Configuration config) {
        String name = config.getAttribute("role", null);
        if (name == null && this.roleManager != null) {
            name = this.roleManager.getRoleForName(config.getName());
        }
        return name;
    }

    private void setParentLocator(ServiceManager locator, String role) throws ServiceException {
        if (this.parentSelector != null) {
            throw new ServiceException(null, "Parent selector is already set");
        }
        this.parentLocator = locator;
        if (locator != null && locator.hasService(role)) {
            Object parent = locator.lookup(role);
            if (parent instanceof CocoonServiceSelector) {
                this.parentSelector = (CocoonServiceSelector)((Object)parent);
            } else {
                throw new IllegalArgumentException("Parent selector is not an extended component selector (" + parent + ")");
            }
        }
    }

    protected boolean canRelease(Object component) {
        if (this.parentSelector != null && this.parentSelector.canRelease(component)) {
            return true;
        }
        return this.componentMapping.containsKey(component);
    }

    public static class Factory
    extends ComponentFactory {
        private final String role;

        public Factory(ComponentEnvironment env, ServiceInfo info, String role) throws Exception {
            super(env, info);
            this.role = role;
        }

        protected void setupObject(Object obj) throws Exception {
            StandaloneServiceSelector component = (StandaloneServiceSelector)((Object)obj);
            ContainerUtil.enableLogging((Object)((Object)component), (Logger)this.environment.logger);
            ContainerUtil.contextualize((Object)((Object)component), (Context)this.environment.context);
            ContainerUtil.service((Object)((Object)component), (ServiceManager)this.environment.serviceManager);
            component.setLoggerManager(this.environment.loggerManager);
            component.setRoleManager(this.environment.roleManager);
            ServiceManager manager = this.environment.serviceManager;
            if (manager instanceof CoreServiceManager) {
                component.setParentLocator(((CoreServiceManager)manager).parentManager, this.role);
            }
            ContainerUtil.configure((Object)((Object)component), (Configuration)this.serviceInfo.getConfiguration());
            ContainerUtil.initialize((Object)((Object)component));
            ContainerUtil.start((Object)((Object)component));
        }
    }
}

