/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.source;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.impl.ResourceSourceFactory;
import org.apache.excalibur.source.impl.URLSourceFactory;

public final class SimpleSourceResolver
extends AbstractLogEnabled
implements ThreadSafe,
Contextualizable,
SourceResolver {
    private String contextBase;
    private ResourceSourceFactory resourceFactory = new ResourceSourceFactory();
    private URLSourceFactory urlFactory = new URLSourceFactory();

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        this.resourceFactory.enableLogging(logger);
        this.urlFactory.enableLogging(logger);
    }

    public void contextualize(Context context) throws ContextException {
        try {
            this.contextBase = context.get((Object)"context-root") instanceof URL ? ((URL)context.get((Object)"context-root")).toExternalForm() : ((File)context.get((Object)"context-root")).toURL().toExternalForm();
        }
        catch (ContextException ce) {
            try {
                this.contextBase = new URL((String)context.get((Object)"root-url")).toExternalForm();
            }
            catch (MalformedURLException mue) {
                throw new ContextException("Malformed URL for root-url", (Throwable)mue);
            }
            catch (ContextException e) {
                try {
                    this.contextBase = new File(System.getProperty("user.dir")).toURL().toExternalForm();
                }
                catch (MalformedURLException mue) {
                    throw new ContextException("Malformed URL for user.dir, and no context-root exists", (Throwable)mue);
                }
            }
        }
        catch (MalformedURLException mue) {
            throw new ContextException("Malformed URL for context-root", (Throwable)mue);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Base URL set to " + this.contextBase);
        }
    }

    public Source resolveURI(String uri) throws MalformedURLException, IOException {
        return this.resolveURI(uri, this.contextBase, null);
    }

    public Source resolveURI(String uri, String base, Map params) throws MalformedURLException, IOException {
        if (uri.startsWith("resource://")) {
            return this.resourceFactory.getSource(uri, null);
        }
        if (uri.startsWith("context://")) {
            return this.resolveURI(uri.substring("context://".length()), this.contextBase, params);
        }
        URL baseURL = new URL(base);
        URL url = new URL(baseURL, uri);
        return this.urlFactory.getSource(url.toExternalForm(), params);
    }

    public void release(Source source) {
    }
}

