/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment;

import java.io.IOException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.PermanentRedirector;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;

public abstract class ForwardRedirector
extends AbstractLogEnabled
implements Redirector,
PermanentRedirector {
    private boolean hasRedirected = false;
    protected Environment env;

    public ForwardRedirector(Environment env) {
        this.env = env;
    }

    public void redirect(boolean sessionMode, String url) throws IOException, ProcessingException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Redirecting to '" + url + "'");
        }
        if (url.startsWith("cocoon:")) {
            this.cocoonRedirect(url);
        } else {
            this.doRedirect(sessionMode, url, false, false);
        }
        this.hasRedirected = true;
    }

    public void permanentRedirect(boolean sessionMode, String url) throws IOException, ProcessingException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Redirecting to '" + url + "'");
        }
        if (url.startsWith("cocoon:")) {
            this.cocoonRedirect(url);
        } else {
            this.doRedirect(sessionMode, url, true, false);
        }
        this.hasRedirected = true;
    }

    public void globalRedirect(boolean sessionMode, String url) throws IOException, ProcessingException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Redirecting to '" + url + "'");
        }
        if (url.startsWith("cocoon:")) {
            this.cocoonRedirect(url);
        } else {
            this.doRedirect(sessionMode, url, false, true);
        }
        this.hasRedirected = true;
    }

    protected abstract void cocoonRedirect(String var1) throws IOException, ProcessingException;

    public boolean hasRedirected() {
        return this.hasRedirected;
    }

    public void sendStatus(int sc) {
        this.env.setStatus(sc);
        this.hasRedirected = true;
    }

    protected void doRedirect(boolean sessionmode, String newURL, boolean permanent, boolean global) throws IOException {
        Request request = ObjectModelHelper.getRequest(this.env.getObjectModel());
        if (sessionmode) {
            String s;
            Session session = null;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("redirect: entering session mode");
            }
            if ((s = request.getRequestedSessionId()) != null && this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Old session ID found in request, id = " + s);
                if (request.isRequestedSessionIdValid()) {
                    this.getLogger().debug("And this old session ID is valid");
                }
            }
            if ((session = request.getSession(true)) == null && this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("redirect session mode: unable to get session object!");
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("redirect: session mode completed, id = " + session.getId());
            }
        }
        this.env.redirect(newURL, global, permanent);
    }
}

