/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.commandline;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.CascadingIOException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.AbstractEnvironment;
import org.apache.cocoon.environment.internal.EnvironmentHelper;
import org.apache.cocoon.serialization.LinkSerializer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractCommandLineEnvironment
extends AbstractEnvironment {
    protected String contentType;
    protected int contentLength;
    protected int statusCode;

    public AbstractCommandLineEnvironment(String uri, String view, File context, OutputStream stream, Logger log) throws MalformedURLException {
        super(uri, view);
        this.enableLogging(log);
        this.outputStream = stream;
        this.statusCode = 0;
    }

    public void redirect(String newURL, boolean global, boolean permanent) throws IOException {
        block21: {
            if (newURL.startsWith("cli:/")) {
                int pos = newURL.indexOf(47, 6);
                newURL = newURL.substring(pos + 1);
            }
            if (newURL.indexOf(":") == -1) {
                newURL = "cocoon:/" + newURL;
            }
            ServiceManager manager = EnvironmentHelper.getSitemapServiceManager();
            SourceResolver resolver = null;
            try {
                resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
                if (newURL.startsWith("cocoon:") && this.getView() != null && this.getView().equals("links")) {
                    LinkSerializer ls = new LinkSerializer();
                    ls.setOutputStream(this.outputStream);
                    Source redirectSource = null;
                    try {
                        redirectSource = resolver.resolveURI(newURL);
                        SourceUtil.parse(manager, redirectSource, (ContentHandler)((Object)ls));
                        break block21;
                    }
                    catch (SourceException se) {
                        throw new CascadingIOException("SourceException: " + (Object)((Object)se), se);
                    }
                    catch (SAXException se) {
                        throw new CascadingIOException("SAXException: " + se, se);
                    }
                    catch (ProcessingException pe) {
                        throw new CascadingIOException("ProcessingException: " + (Object)((Object)pe), (Throwable)((Object)pe));
                    }
                    finally {
                        resolver.release(redirectSource);
                    }
                }
                Source redirectSource = null;
                try {
                    redirectSource = resolver.resolveURI(newURL);
                    InputStream is = redirectSource.getInputStream();
                    byte[] buffer = new byte[8192];
                    int length = -1;
                    while ((length = is.read(buffer)) > -1) {
                        this.outputStream.write(buffer, 0, length);
                    }
                }
                catch (SourceException se) {
                    throw new CascadingIOException("SourceException: " + (Object)((Object)se), se);
                }
                finally {
                    resolver.release(redirectSource);
                }
            }
            catch (ServiceException se) {
                throw new CascadingIOException("Unable to get source resolver.", se);
            }
            finally {
                manager.release((Object)resolver);
            }
        }
    }

    public void setStatus(int statusCode) {
        this.statusCode = statusCode;
    }

    public int getStatus() {
        return this.statusCode;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isExternal() {
        return true;
    }
}

