/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.internal.CloningInheritableThreadLocal;
import org.apache.cocoon.environment.internal.EnvironmentInfo;
import org.apache.cocoon.environment.internal.EnvironmentStack;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.Source;

public class EnvironmentHelper
extends AbstractLogEnabled
implements SourceResolver,
Serviceable,
Disposable {
    protected static final InheritableThreadLocal environmentStack = new CloningInheritableThreadLocal();
    protected org.apache.excalibur.source.SourceResolver resolver;
    protected ServiceManager manager;
    protected String prefix;
    protected String context;
    protected String lastPrefix;

    public EnvironmentHelper(String context) {
        this.context = context;
    }

    public EnvironmentHelper(EnvironmentHelper parent) {
        this.context = parent.context;
        this.lastPrefix = parent.lastPrefix;
        this.prefix = parent.prefix;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.resolver = (org.apache.excalibur.source.SourceResolver)this.manager.lookup(org.apache.excalibur.source.SourceResolver.ROLE);
        Source source = null;
        try {
            source = this.resolver.resolveURI(this.context);
            this.context = source.getURI();
        }
        catch (IOException ioe) {
            throw new ServiceException("EnvironmentHelper", "Unable to resolve environment context. ", (Throwable)ioe);
        }
        finally {
            this.resolver.release(source);
        }
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.resolver);
            this.resolver = null;
            this.manager = null;
        }
    }

    public void release(Source source) {
        this.resolver.release(source);
    }

    public Source resolveURI(String location, String baseURI, Map parameters) throws MalformedURLException, IOException {
        return this.resolver.resolveURI(location, baseURI == null ? this.context : baseURI, parameters);
    }

    public Source resolveURI(String location) throws MalformedURLException, IOException {
        return this.resolveURI(location, null, null);
    }

    public String getContext() {
        return this.context;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void changeContext(Environment env) throws ProcessingException {
        if (this.lastPrefix != null) {
            String uris = env.getURI();
            if (!uris.startsWith(this.lastPrefix)) {
                String message = "The current URI (" + uris + ") doesn't start with given prefix (" + this.lastPrefix + ")";
                throw new ProcessingException(message);
            }
            int l = this.lastPrefix.length();
            env.setURI(this.prefix, uris.substring(l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeContext(Source newSource, String newPrefix) throws IOException {
        block13: {
            String newContext;
            block14: {
                int l;
                newContext = newSource.getURI();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Changing Cocoon context");
                    this.getLogger().debug("  from context(" + this.context + ") and prefix(" + this.prefix + ")");
                    this.getLogger().debug("  to context(" + newContext + ") and prefix(" + newPrefix + ")");
                }
                if ((l = newPrefix.length()) >= 1) {
                    this.lastPrefix = newPrefix;
                    if (this.prefix == null) {
                        this.prefix = "";
                    }
                    StringBuffer buffer = new StringBuffer(this.prefix);
                    buffer.append(newPrefix);
                    if (buffer.charAt(buffer.length() - 1) != '/') {
                        buffer.append('/');
                        this.lastPrefix = this.lastPrefix + '/';
                    }
                    this.prefix = buffer.toString();
                } else {
                    this.lastPrefix = null;
                }
                if (!SourceUtil.getScheme(this.context).equals("zip")) break block14;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Base context is zip: " + this.context);
                }
                Source source = null;
                try {
                    source = this.resolver.resolveURI(this.context + newContext);
                    this.context = source.getURI();
                }
                catch (Throwable throwable) {
                    this.resolver.release(source);
                    throw throwable;
                }
                this.resolver.release(source);
                break block13;
            }
            String sContext = newContext.charAt(0) == '/' ? "file:" + newContext : (newContext.indexOf(58) > 1 ? newContext : this.context + '/' + newContext);
            int i = sContext.lastIndexOf(47);
            if (i != -1 && i + 1 < sContext.length()) {
                sContext = sContext.substring(0, i + 1);
            }
            Source source = null;
            try {
                source = this.resolver.resolveURI(sContext);
                this.context = source.getURI();
            }
            finally {
                this.resolver.release(source);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("New context is " + this.context);
        }
    }

    public static void enterProcessor(Processor processor, ServiceManager manager, Environment env) throws ProcessingException {
        if (null == processor) {
            throw new ProcessingException("Processor is not set.");
        }
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        if (stack == null) {
            stack = new EnvironmentStack();
            environmentStack.set(stack);
        }
        stack.pushInfo(new EnvironmentInfo(processor, stack.getOffset(), manager, env));
        stack.setOffset(stack.size() - 1);
    }

    public static void leaveProcessor() {
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        EnvironmentInfo info = (EnvironmentInfo)stack.pop();
        stack.setOffset(info.oldStackCount);
    }

    public static int markEnvironment() {
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        if (stack != null) {
            return stack.size();
        }
        return 0;
    }

    public static void checkEnvironment(int depth, Logger logger) throws Exception {
        int currentDepth;
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        int n = currentDepth = stack != null ? stack.size() : 0;
        if (currentDepth != depth) {
            logger.error("ENVIRONMENT STACK HAS NOT BEEN CLEANED PROPERLY!");
            throw new ProcessingException("Environment stack has not been cleaned up properly. Please report this (and if possible, together with a test case) to the Cocoon developers.");
        }
    }

    public static Environment getCurrentEnvironment() {
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        if (stack != null && !stack.empty()) {
            EnvironmentInfo info = stack.getCurrentInfo();
            return info.environment;
        }
        return null;
    }

    public static Processor getCurrentProcessor() {
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        if (stack != null && !stack.isEmpty()) {
            EnvironmentInfo info = stack.getCurrentInfo();
            return info.processor;
        }
        return null;
    }

    public static ServiceManager getSitemapServiceManager() {
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        if (stack != null && !stack.isEmpty()) {
            EnvironmentInfo info = stack.getCurrentInfo();
            return info.manager;
        }
        return null;
    }

    public static XMLConsumer createEnvironmentAwareConsumer(XMLConsumer consumer) {
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        EnvironmentInfo info = stack.getCurrentInfo();
        return stack.getEnvironmentAwareConsumerWrapper(consumer, info.oldStackCount);
    }
}

