/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.wrapper;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.components.source.impl.SitemapSourceInfo;
import org.apache.cocoon.environment.AbstractEnvironment;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.wrapper.RequestWrapper;
import org.apache.cocoon.environment.wrapper.ResponseWrapper;
import org.apache.cocoon.util.BufferedOutputStream;

public class EnvironmentWrapper
extends AbstractEnvironment {
    protected final Environment environment;
    protected String redirectURL;
    protected final Request request;
    protected OutputStream outputStream;
    protected String contentType;
    protected boolean internalRedirect = false;

    public EnvironmentWrapper(Environment env, SitemapSourceInfo info, Logger logger) {
        this(env, info, logger, true);
    }

    public EnvironmentWrapper(Environment env, SitemapSourceInfo info, Logger logger, boolean wrapResponse) {
        super(env.getURI(), info.view, env.getAction());
        this.enableLogging(logger);
        this.environment = env;
        Map oldObjectModel = env.getObjectModel();
        if (oldObjectModel instanceof HashMap) {
            this.objectModel = (Map)((HashMap)oldObjectModel).clone();
        } else {
            this.objectModel = new HashMap(oldObjectModel.size() * 2);
            Iterator entries = oldObjectModel.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                this.objectModel.put(entry.getKey(), entry.getValue());
            }
        }
        this.request = new RequestWrapper(ObjectModelHelper.getRequest(oldObjectModel), info.requestURI, info.queryString, this, info.rawMode);
        this.objectModel.put("request", this.request);
        if (wrapResponse) {
            ResponseWrapper response = new ResponseWrapper(ObjectModelHelper.getResponse(oldObjectModel));
            this.objectModel.put("response", response);
        }
        this.setURI(info.prefix, info.uri);
    }

    public void redirect(String newURL, boolean global, boolean permanent) throws IOException {
        if (!global && !this.internalRedirect) {
            this.redirectURL = newURL;
        } else {
            this.environment.redirect(newURL, global, permanent);
        }
    }

    public OutputStream getOutputStream(int bufferSize) throws IOException {
        return this.outputStream == null ? this.environment.getOutputStream(bufferSize) : this.outputStream;
    }

    public void setOutputStream(OutputStream stream) {
        this.outputStream = stream;
    }

    public boolean tryResetResponse() throws IOException {
        OutputStream os = this.getOutputStream(-1);
        if (os != null && os instanceof BufferedOutputStream) {
            ((BufferedOutputStream)os).clearBuffer();
            return true;
        }
        return super.tryResetResponse();
    }

    public void commitResponse() throws IOException {
        OutputStream os = this.getOutputStream(-1);
        if (os != null && os instanceof BufferedOutputStream) {
            ((BufferedOutputStream)os).realFlush();
        } else {
            super.commitResponse();
        }
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public void reset() {
        this.redirectURL = null;
    }

    public void setStatus(int statusCode) {
    }

    public void setContentLength(int length) {
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Object getAttribute(String name) {
        Object value = super.getAttribute(name);
        if (value == null) {
            value = this.environment.getAttribute(name);
        }
        return value;
    }

    public void removeAttribute(String name) {
        super.removeAttribute(name);
        this.environment.removeAttribute(name);
    }

    public boolean isExternal() {
        return false;
    }

    public void setInternalRedirect(boolean flag) {
        this.internalRedirect = flag;
        if (flag) {
            ((RequestWrapper)this.request).setRequestURI(this.prefix, this.uri);
        }
    }

    public boolean isInternalRedirect() {
        return this.internalRedirect;
    }
}

