/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.i18n;

import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.Session;

public class I18nUtils {
    private static final String LOCALE_DELIMITER = "_-@.";

    private I18nUtils() {
    }

    public static Locale parseLocale(String localeString, Locale defaultLocale) {
        if (localeString != null) {
            StringTokenizer st = new StringTokenizer(localeString, LOCALE_DELIMITER);
            String l = st.hasMoreElements() ? st.nextToken() : defaultLocale.getLanguage();
            String c = st.hasMoreElements() ? st.nextToken() : "";
            String v = st.hasMoreElements() ? st.nextToken() : "";
            return new Locale(l, c, v);
        }
        return defaultLocale;
    }

    public static Locale parseLocale(String localeString) {
        return I18nUtils.parseLocale(localeString, Locale.getDefault());
    }

    public static Locale findLocale(Map objectModel, String attribute, Parameters parameters, Locale defaultLocale, boolean useLocale, boolean useLocales, boolean useBlankLocale, LocaleValidator test) {
        Cookie[] cookies;
        Session session;
        Locale locale;
        Request request = ObjectModelHelper.getRequest(objectModel);
        String localeStr = request.getParameter(attribute);
        if (localeStr != null) {
            locale = I18nUtils.parseLocale(localeStr);
            if (test == null || test.test("request", locale)) {
                return locale;
            }
        }
        if ((session = request.getSession(false)) != null && (localeStr = (String)session.getAttribute(attribute)) != null) {
            locale = I18nUtils.parseLocale(localeStr);
            if (test == null || test.test("session", locale)) {
                return locale;
            }
        }
        if ((cookies = request.getCookies()) != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (!cookie.getName().equals(attribute)) continue;
                localeStr = cookie.getValue();
                locale = I18nUtils.parseLocale(localeStr);
                if (test != null && !test.test("cookie", locale)) break;
                return locale;
            }
        }
        if (parameters != null && (localeStr = parameters.getParameter("locale", null)) != null) {
            locale = I18nUtils.parseLocale(localeStr);
            if (test == null || test.test("sitemap", locale)) {
                return locale;
            }
        }
        if (useLocale && !useLocales) {
            locale = request.getLocale();
            if (test == null || test.test("request", locale)) {
                return locale;
            }
        }
        if (useLocales) {
            Enumeration locales = request.getLocales();
            while (locales.hasMoreElements()) {
                locale = (Locale)locales.nextElement();
                if (test != null && !test.test("request", locale)) continue;
                return locale;
            }
        }
        if (defaultLocale != null) {
            locale = defaultLocale;
            if (test == null || test.test("default", locale)) {
                return locale;
            }
        }
        if (useBlankLocale) {
            locale = new Locale("", "");
            if (test == null || test.test("blank", locale)) {
                return locale;
            }
        }
        return null;
    }

    public static Locale findLocale(Map objectModel, String attribute, Parameters parameters, Locale defaultLocale, boolean useLocale) {
        return I18nUtils.findLocale(objectModel, attribute, parameters, defaultLocale, useLocale, false, false, null);
    }

    public static void storeLocale(Map objectModel, String attribute, String locale, boolean storeInRequest, boolean storeInSession, boolean storeInCookie, boolean createSession) {
        Session session;
        Request request;
        if (storeInRequest) {
            request = ObjectModelHelper.getRequest(objectModel);
            request.setAttribute(attribute, locale);
        }
        if (storeInSession && (session = (request = ObjectModelHelper.getRequest(objectModel)).getSession(createSession)) != null) {
            session.setAttribute(attribute, locale);
        }
        if (storeInCookie) {
            Response response = ObjectModelHelper.getResponse(objectModel);
            response.addCookie(response.createCookie(attribute, locale));
        }
    }

    public static interface LocaleValidator {
        public boolean test(String var1, Locale var2);
    }
}

