/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.reading;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RescaleOp;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.ResourceReader;
import org.apache.commons.lang.BooleanUtils;
import org.xml.sax.SAXException;

public final class ImageReader
extends ResourceReader {
    private int width;
    private int height;
    private float[] scaleColor = new float[3];
    private float[] offsetColor = new float[3];
    private RescaleOp colorFilter = null;
    private boolean enlarge;
    private static final String ENLARGE_DEFAULT = "true";
    private boolean fitUniform;
    private static final String FIT_DEFAULT = "false";
    private ColorConvertOp grayscaleFilter = null;
    private static final String GRAYSCALE_DEFAULT = "false";

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.width = par.getParameterAsInteger("width", 0);
        this.height = par.getParameterAsInteger("height", 0);
        this.scaleColor[0] = par.getParameterAsFloat("scaleRed", -1.0f);
        this.scaleColor[1] = par.getParameterAsFloat("scaleGreen", -1.0f);
        this.scaleColor[2] = par.getParameterAsFloat("scaleBlue", -1.0f);
        this.offsetColor[0] = par.getParameterAsFloat("offsetRed", 0.0f);
        this.offsetColor[1] = par.getParameterAsFloat("offsetGreen", 0.0f);
        this.offsetColor[2] = par.getParameterAsFloat("offsetBlue", 0.0f);
        boolean filterColor = false;
        for (int i = 0; i < 3; ++i) {
            if (this.scaleColor[i] != -1.0f) {
                filterColor = true;
            } else {
                this.scaleColor[i] = 1.0f;
            }
            if (this.offsetColor[i] == 0.0f) continue;
            filterColor = true;
        }
        this.colorFilter = filterColor ? new RescaleOp(this.scaleColor, this.offsetColor, null) : null;
        String grayscalePar = par.getParameter("grayscale", "false");
        this.grayscaleFilter = BooleanUtils.toBoolean((String)grayscalePar) ? new ColorConvertOp(ColorSpace.getInstance(1003), null) : null;
        String enlargePar = par.getParameter("allow-enlarging", ENLARGE_DEFAULT);
        this.enlarge = BooleanUtils.toBoolean((String)enlargePar);
        String fitUniformPar = par.getParameter("fit-uniform", "false");
        this.fitUniform = BooleanUtils.toBoolean((String)fitUniformPar);
    }

    private AffineTransform getTransform(double ow, double oh, double nw, double nh) {
        double wm = 1.0;
        double hm = 1.0;
        if (this.fitUniform) {
            if (ow / oh > nw / nh) {
                nh = 0.0;
            } else {
                nw = 0.0;
            }
        }
        if (nw > 0.0) {
            wm = nw / ow;
            hm = nh > 0.0 ? nh / oh : wm;
        } else if (nh > 0.0) {
            wm = hm = nh / oh;
        }
        if (!this.enlarge) {
            if (nw > ow && nh <= 0.0 || nh > oh && nw <= 0.0) {
                wm = 1.0;
                hm = 1.0;
            } else if (nw > ow) {
                wm = 1.0;
            } else if (nh > oh) {
                hm = 1.0;
            }
        }
        return new AffineTransform(wm, 0.0, 0.0, hm, 0.0, 0.0);
    }

    protected void processStream(InputStream inputStream) throws IOException, ProcessingException {
        if (this.width > 0 || this.height > 0 || null != this.colorFilter || null != this.grayscaleFilter) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("image " + (this.width == 0 ? "?" : Integer.toString(this.width)) + "x" + (this.height == 0 ? "?" : Integer.toString(this.height)) + " expires: " + this.expires);
            }
            this.response.setHeader("Accept-Ranges", "none");
            try {
                BufferedImage original;
                JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)inputStream);
                BufferedImage currentImage = original = decoder.decodeAsBufferedImage();
                if (this.width > 0 || this.height > 0) {
                    JPEGDecodeParam decodeParam = decoder.getJPEGDecodeParam();
                    double ow = decodeParam.getWidth();
                    double oh = decodeParam.getHeight();
                    AffineTransformOp filter = new AffineTransformOp(this.getTransform(ow, oh, this.width, this.height), 2);
                    WritableRaster scaledRaster = filter.createCompatibleDestRaster(currentImage.getRaster());
                    filter.filter(currentImage.getRaster(), scaledRaster);
                    currentImage = new BufferedImage(original.getColorModel(), scaledRaster, true, null);
                }
                if (null != this.grayscaleFilter) {
                    this.grayscaleFilter.filter(currentImage, currentImage);
                }
                if (null != this.colorFilter) {
                    this.colorFilter.filter(currentImage, currentImage);
                }
                if (!this.handleJVMBug()) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("No need to handle JVM bug");
                    }
                    JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)this.out);
                    encoder.encode(currentImage);
                } else {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Need to handle JVM bug");
                    }
                    ByteArrayOutputStream bstream = new ByteArrayOutputStream();
                    JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)bstream);
                    encoder.encode(currentImage);
                    this.out.write(bstream.toByteArray());
                }
                this.out.flush();
            }
            catch (ImageFormatException e) {
                throw new ProcessingException("Error reading the image. Note that only JPEG images are currently supported.");
            }
            finally {
                inputStream.close();
            }
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("passing original resource");
            }
            super.processStream(inputStream);
        }
    }

    public Serializable getKey() {
        return this.inputSource.getURI() + ':' + this.width + ':' + this.height + ":" + this.scaleColor[0] + ":" + this.scaleColor[1] + ":" + this.scaleColor[2] + ":" + this.offsetColor[0] + ":" + this.offsetColor[1] + ":" + this.offsetColor[2] + ":" + (null == this.grayscaleFilter ? "color" : "grayscale") + ":" + super.getKey();
    }

    protected boolean handleJVMBug() {
        String java_version = System.getProperty("java.version", "0.0.0");
        boolean handleJVMBug = true;
        char major = java_version.charAt(0);
        char minor = java_version.charAt(2);
        handleJVMBug = major == '0' || major == '1' ? minor == '0' || minor == '1' || minor == '2' || minor == '3' : true;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Running java.version " + String.valueOf(java_version) + " need to handle JVM bug " + String.valueOf(handleJVMBug));
        }
        return handleJVMBug;
    }
}

