/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.selection;

import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.selection.Selector;

public class HeaderSelector
extends AbstractLogEnabled
implements Configurable,
ThreadSafe,
Selector {
    protected String defaultName;

    public void configure(Configuration config) throws ConfigurationException {
        this.defaultName = config.getChild("parameter-name").getValue(null);
        if (this.defaultName != null) {
            this.getLogger().warn("'parameter-name' is deprecated. Please use 'header-name'");
        }
        this.defaultName = config.getChild("header-name").getValue(this.defaultName);
    }

    public boolean select(String expression, Map objectModel, Parameters parameters) {
        String name = parameters.getParameter("parameter-name", null);
        if (name != null) {
            this.getLogger().warn("'parameter-name' is deprecated. Please use 'header-name'");
        } else {
            name = this.defaultName;
        }
        name = parameters.getParameter("header-name", name);
        if (name == null) {
            this.getLogger().warn("No header name given -- failing.");
            return false;
        }
        String value = ObjectModelHelper.getRequest(objectModel).getHeader(name);
        if (value == null) {
            this.getLogger().debug("Header '" + name + "' not set -- failing.");
            return false;
        }
        return value.equals(expression);
    }
}

