/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.serialization;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.serialization.AbstractSerializer;
import org.apache.cocoon.serialization.Serializer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.NamespaceSupport;

public class ZipArchiveSerializer
extends AbstractSerializer
implements Disposable,
Serviceable {
    public static final String ZIP_NAMESPACE = "http://apache.org/cocoon/zip-archive/1.0";
    private static final int START_STATE = 0;
    private static final int IN_ZIP_STATE = 1;
    private static final int IN_CONTENT_STATE = 2;
    protected ServiceManager manager;
    protected ServiceSelector selector;
    protected ZipOutputStream zipOutput;
    protected int state = 0;
    protected SourceResolver resolver;
    protected Serializer serializer;
    protected int contentDepth;
    private NamespaceSupport nsSupport = new NamespaceSupport();
    private SAXException exception;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    public String getMimeType() {
        return "application/zip";
    }

    public void startDocument() throws SAXException {
        this.state = 0;
        this.zipOutput = new ZipOutputStream(this.output);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.state == 2) {
            super.startPrefixMapping(prefix, uri);
        } else if (!uri.equals(ZIP_NAMESPACE)) {
            this.nsSupport.declarePrefix(prefix, uri);
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.exception != null) {
            throw this.exception;
        }
        switch (this.state) {
            case 0: {
                if (namespaceURI.equals(ZIP_NAMESPACE) && localName.equals("archive")) {
                    this.nsSupport.pushContext();
                    this.state = 1;
                    break;
                }
                this.exception = new SAXException("Expecting 'archive' root element (got '" + localName + "')");
                throw this.exception;
            }
            case 1: {
                if (namespaceURI.equals(ZIP_NAMESPACE) && localName.equals("entry")) {
                    this.nsSupport.pushContext();
                    this.addEntry(atts);
                    break;
                }
                this.exception = new SAXException("Expecting 'entry' element (got '" + localName + "')");
                throw this.exception;
            }
            case 2: {
                ++this.contentDepth;
                super.startElement(namespaceURI, localName, qName, atts);
            }
        }
    }

    public void characters(char[] buffer, int offset, int length) throws SAXException {
        if (this.state == 2 && this.contentDepth > 0) {
            super.characters(buffer, offset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEntry(Attributes atts) throws SAXException {
        block18: {
            String name = atts.getValue("name");
            if (name == null) {
                this.exception = new SAXException("No name given to the Zip entry");
                throw this.exception;
            }
            String src = atts.getValue("src");
            String serializerType = atts.getValue("serializer");
            if (src == null && serializerType == null) {
                this.exception = new SAXException("No source nor serializer given for the Zip entry '" + name + "'");
                throw this.exception;
            }
            if (src != null && serializerType != null) {
                this.exception = new SAXException("Cannot specify both 'src' and 'serializer' on a Zip entry '" + name + "'");
                throw this.exception;
            }
            try {
                ZipEntry entry = new ZipEntry(name);
                this.zipOutput.putNextEntry(entry);
                if (src != null) {
                    Source source = this.resolver.resolveURI(src);
                    try {
                        InputStream sourceInput = source.getInputStream();
                        try {
                            int len;
                            byte[] buffer = new byte[4096];
                            while ((len = sourceInput.read(buffer)) > 0) {
                                this.zipOutput.write(buffer, 0, len);
                            }
                        }
                        finally {
                            sourceInput.close();
                        }
                        this.zipOutput.closeEntry();
                        break block18;
                    }
                    finally {
                        this.resolver.release(source);
                    }
                }
                if (this.selector == null) {
                    this.selector = (ServiceSelector)this.manager.lookup(Serializer.ROLE + "Selector");
                }
                this.serializer = (Serializer)this.selector.select((Object)serializerType);
                this.serializer.setOutputStream(new FilterOutputStream(this.zipOutput){

                    public void close() {
                    }
                });
                this.setConsumer(this.serializer);
                this.serializer.startDocument();
                Enumeration<String> prefixes = this.nsSupport.getPrefixes();
                while (prefixes.hasMoreElements()) {
                    String prefix = prefixes.nextElement();
                    super.startPrefixMapping(prefix, this.nsSupport.getURI(prefix));
                }
                this.state = 2;
                this.contentDepth = 0;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (SAXException e) {
                this.exception = e;
                throw this.exception;
            }
            catch (Exception e) {
                this.exception = new SAXException(e);
                throw this.exception;
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.state == 2) {
            super.endElement(namespaceURI, localName, qName);
            --this.contentDepth;
            if (this.contentDepth == 0) {
                Enumeration<String> prefixes = this.nsSupport.getPrefixes();
                while (prefixes.hasMoreElements()) {
                    String prefix = prefixes.nextElement();
                    super.endPrefixMapping(prefix);
                }
                super.endDocument();
                try {
                    this.zipOutput.closeEntry();
                }
                catch (IOException e) {
                    this.exception = new SAXException(e);
                    throw this.exception;
                }
                super.setConsumer(null);
                this.selector.release((Object)this.serializer);
                this.serializer = null;
                this.state = 1;
            }
        } else {
            this.nsSupport.popContext();
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.zipOutput.finish();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void recycle() {
        this.exception = null;
        if (this.serializer != null) {
            this.selector.release((Object)this.serializer);
        }
        if (this.selector != null) {
            this.manager.release((Object)this.selector);
        }
        this.nsSupport.reset();
        super.recycle();
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.resolver);
            this.resolver = null;
            this.manager = null;
        }
    }
}

