/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.serialization.Serializer;
import org.apache.cocoon.transformation.AbstractSAXTransformer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.cocoon.xml.dom.DOMUtil;
import org.apache.excalibur.source.ModifiableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.xml.dom.DOMParser;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentFragment;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SourceWritingTransformer
extends AbstractSAXTransformer
implements Disposable {
    public static final String SWT_URI = "http://apache.org/cocoon/source/1.0";
    public static final String DEFAULT_SERIALIZER = "xml";
    public static final String WRITE_ELEMENT = "write";
    public static final String INSERT_ELEMENT = "insert";
    public static final String PATH_ELEMENT = "path";
    public static final String FRAGMENT_ELEMENT = "fragment";
    public static final String REPLACE_ELEMENT = "replace";
    public static final String DELETE_ELEMENT = "delete";
    public static final String SOURCE_ELEMENT = "source";
    public static final String REINSERT_ELEMENT = "reinsert";
    public static final String RESULT_ELEMENT = "sourceResult";
    public static final String EXECUTION_ELEMENT = "execution";
    public static final String BEHAVIOUR_ELEMENT = "behaviour";
    public static final String ACTION_ELEMENT = "action";
    public static final String MESSAGE_ELEMENT = "message";
    public static final String SERIALIZER_ELEMENT = "serializer";
    public static final String SERIALIZER_ATTRIBUTE = "serializer";
    public static final String CREATE_ATTRIBUTE = "create";
    public static final String OVERWRITE_ATTRIBUTE = "overwrite";
    public static final String RESULT_FAILED = "failed";
    public static final String RESULT_SUCCESS = "success";
    public static final String ACTION_NONE = "none";
    public static final String ACTION_NEW = "new";
    public static final String ACTION_OVER = "overwritten";
    public static final String ACTION_DELETE = "deleted";
    private static final int STATE_OUTSIDE = 0;
    private static final int STATE_INSERT = 1;
    private static final int STATE_PATH = 3;
    private static final int STATE_FRAGMENT = 4;
    private static final int STATE_REPLACE = 5;
    private static final int STATE_FILE = 6;
    private static final int STATE_REINSERT = 7;
    private static final int STATE_WRITE = 8;
    private static final int STATE_DELETE = 9;
    private int state;
    private int parent_state;
    protected String configuredSerializerName;
    protected XPathProcessor xpathProcessor;

    public SourceWritingTransformer() {
        this.defaultNamespaceURI = SWT_URI;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.configuredSerializerName = configuration.getChild("serializer").getValue(DEFAULT_SERIALIZER);
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.configuredSerializerName = par.getParameter("serializer", this.configuredSerializerName);
        this.state = 0;
    }

    public void startTransformingElement(String uri, String name, String raw, Attributes attr) throws SAXException, IOException, ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Start transforming element. uri=" + uri + ", name=" + name + ", raw=" + raw + ", attr=" + attr);
        }
        if (this.state == 0 && (name.equals(INSERT_ELEMENT) || name.equals(WRITE_ELEMENT))) {
            this.parent_state = this.state = name.equals(INSERT_ELEMENT) ? 1 : 8;
            if (attr.getValue(CREATE_ATTRIBUTE) != null && attr.getValue(CREATE_ATTRIBUTE).equals("false")) {
                this.stack.push("false");
            } else {
                this.stack.push("true");
            }
            if (attr.getValue(OVERWRITE_ATTRIBUTE) != null && attr.getValue(OVERWRITE_ATTRIBUTE).equals("false")) {
                this.stack.push("false");
            } else {
                this.stack.push("true");
            }
            this.stack.push(attr.getValue("serializer"));
            this.stack.push("END");
        } else if (this.state == 0 && name.equals(DELETE_ELEMENT)) {
            this.parent_state = this.state = 9;
            this.stack.push("END");
        } else if (name.equals(SOURCE_ELEMENT) && (this.state == 1 || this.state == 8 || this.state == 9)) {
            this.state = 6;
            this.startTextRecording();
        } else if (name.equals(PATH_ELEMENT) && (this.state == 1 || this.state == 8 || this.state == 9)) {
            this.state = 3;
            this.startTextRecording();
        } else if (name.equals(REPLACE_ELEMENT) && this.state == 1) {
            this.state = 5;
            this.startTextRecording();
        } else if (name.equals(FRAGMENT_ELEMENT) && (this.state == 1 || this.state == 8 || this.state == 9)) {
            this.state = 4;
            this.startRecording();
        } else if (name.equals(REINSERT_ELEMENT) && this.state == 1) {
            this.state = 7;
            this.startTextRecording();
        } else {
            super.startTransformingElement(uri, name, raw, attr);
        }
    }

    public void endTransformingElement(String uri, String name, String raw) throws SAXException, IOException, ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("End transforming element. uri=" + uri + ", name=" + name + ", raw=" + raw);
        }
        if (name.equals(INSERT_ELEMENT) && this.state == 1 || name.equals(WRITE_ELEMENT) && this.state == 8) {
            String tag;
            DocumentFragment fragment = null;
            String sourceName = null;
            String path = this.state == 1 ? null : "/";
            String replacePath = null;
            String reinsert = null;
            do {
                if ((tag = (String)this.stack.pop()).equals("PATH")) {
                    path = (String)this.stack.pop();
                    continue;
                }
                if (tag.equals("FILE")) {
                    sourceName = (String)this.stack.pop();
                    continue;
                }
                if (tag.equals("FRAGMENT")) {
                    fragment = (DocumentFragment)this.stack.pop();
                    continue;
                }
                if (tag.equals("REPLACE")) {
                    replacePath = (String)this.stack.pop();
                    continue;
                }
                if (!tag.equals("REINSERT")) continue;
                reinsert = (String)this.stack.pop();
            } while (!tag.equals("END"));
            String localSerializer = (String)this.stack.pop();
            boolean overwrite = this.stack.pop().equals("true");
            boolean create = this.stack.pop().equals("true");
            this.insertFragment(sourceName, path, fragment, replacePath, create, overwrite, reinsert, localSerializer, name);
            this.state = 0;
        } else if (name.equals(DELETE_ELEMENT) && this.state == 9) {
            String tag;
            String sourceName = null;
            do {
                if ((tag = (String)this.stack.pop()).equals("FILE")) {
                    sourceName = (String)this.stack.pop();
                    continue;
                }
                if (!tag.equals("FRAGMENT")) continue;
                this.stack.pop();
            } while (!tag.equals("END"));
            this.deleteSource(sourceName);
            this.state = 0;
        } else if (name.equals(SOURCE_ELEMENT) && this.state == 6) {
            this.state = this.parent_state;
            this.stack.push(this.endTextRecording());
            this.stack.push("FILE");
        } else if (name.equals(PATH_ELEMENT) && this.state == 3) {
            this.state = this.parent_state;
            this.stack.push(this.endTextRecording());
            this.stack.push("PATH");
        } else if (name.equals(REPLACE_ELEMENT) && this.state == 5) {
            this.state = this.parent_state;
            this.stack.push(this.endTextRecording());
            this.stack.push("REPLACE");
        } else if (name.equals(FRAGMENT_ELEMENT) && this.state == 4) {
            this.state = this.parent_state;
            this.stack.push(this.endRecording());
            this.stack.push("FRAGMENT");
        } else if (name.equals(REINSERT_ELEMENT) && this.state == 7) {
            this.state = this.parent_state;
            this.stack.push(this.endTextRecording());
            this.stack.push("REINSERT");
        } else {
            super.endTransformingElement(uri, name, raw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSource(String systemID) throws ProcessingException, IOException, SAXException {
        Source source = null;
        try {
            source = this.resolver.resolveURI(systemID);
            if (!(source instanceof ModifiableSource)) {
                throw new ProcessingException("Source '" + systemID + "' is not writeable.");
            }
            ((ModifiableSource)source).delete();
            this.reportResult(ACTION_NONE, DELETE_ELEMENT, "source deleted successfully", systemID, RESULT_SUCCESS, ACTION_DELETE);
        }
        catch (SourceException se) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("FAIL exception: " + (Object)((Object)se), (Throwable)se);
            }
            this.reportResult(ACTION_NONE, DELETE_ELEMENT, "unable to delete source: " + se.getMessage(), systemID, RESULT_FAILED, ACTION_DELETE);
        }
        finally {
            this.resolver.release(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void insertFragment(String systemID, String path, DocumentFragment fragment, String replacePath, boolean create, boolean overwrite, String reinsertPath, String localSerializer, String tagname) throws SAXException, IOException, ProcessingException {
        block62: {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Insert fragment. systemID=" + systemID + ", path=" + path + ", replace=" + replacePath + ", create=" + create + ", overwrite=" + overwrite + ", reinsert=" + reinsertPath + ", fragment=" + (fragment == null ? "null" : XMLUtils.serializeNode(fragment)));
            }
            if (systemID == null) {
                throw new ProcessingException("insertFragment: systemID is required.");
            }
            if (path == null) {
                throw new ProcessingException("insertFragment: path is required.");
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (fragment == null) {
                throw new ProcessingException("insertFragment: fragment is required.");
            }
            source = null;
            resource = null;
            failed = true;
            exists = false;
            message = "";
            target = systemID;
            try {
                source = this.resolver.resolveURI(systemID);
                if (!(source instanceof ModifiableSource)) {
                    throw new ProcessingException("Source '" + systemID + "' is not writeable.");
                }
                ws = (ModifiableSource)source;
                exists = ws.exists();
                target = source.getURI();
                if (exists && this.state == 1) {
                    message = "content inserted at: " + path;
                    resource = SourceUtil.toDOM(source);
                    importNode = resource.importNode(fragment, true);
                    parent = DOMUtil.selectSingleNode(resource, path, this.xpathProcessor);
                    if (replacePath != null) {
                        try {
                            for (replaceNode = DOMUtil.getSingleNode(parent, replacePath, this.xpathProcessor); replaceNode != null && !replaceNode.getParentNode().equals(parent); replaceNode = replaceNode.getParentNode()) {
                            }
                            if (replaceNode != null) {
                                if (overwrite) {
                                    if (parent.getNodeType() == 9) {
                                        parser = (DOMParser)this.manager.lookup(DOMParser.ROLE);
                                        try {
                                            resource = parser.createDocument();
                                        }
                                        finally {
                                            this.manager.release((Object)parser);
                                        }
                                        resource.appendChild(resource.importNode(importNode, true));
                                        parent = resource;
                                        replaceNode = resource.importNode(replaceNode, true);
                                    } else {
                                        parent.replaceChild(importNode, replaceNode);
                                    }
                                    message = message + ", replacing: " + replacePath;
                                    if (reinsertPath == null) ** GOTO lbl96
                                    insertAt = DOMUtil.getSingleNode(parent, reinsertPath, this.xpathProcessor);
                                    if (insertAt != null) {
                                        while (replaceNode.hasChildNodes()) {
                                            insertAt.appendChild(replaceNode.getFirstChild());
                                        }
                                    }
                                    message = "replace failed, could not find your reinsert path: " + reinsertPath;
                                    resource = null;
                                }
                                message = "replace failed, no overwrite allowed.";
                                resource = null;
                            }
                            parent.appendChild(importNode);
                        }
                        catch (TransformerException sax) {
                            throw new ProcessingException("TransformerException: " + sax, sax);
                        }
                    } else {
                        parent.appendChild(importNode);
                    }
                } else if (create) {
                    parser = (DOMParser)this.manager.lookup(DOMParser.ROLE);
                    try {
                        resource = parser.createDocument();
                    }
                    finally {
                        this.manager.release((Object)parser);
                    }
                    importNode = resource.importNode(fragment, true);
                    if (path.equals("")) {
                        resource.appendChild(importNode.getFirstChild());
                        message = "entire source overwritten";
                    } else {
                        parent = DOMUtil.selectSingleNode(resource, path, this.xpathProcessor);
                        parent.appendChild(importNode);
                        message = "content appended to: " + path;
                    }
                } else {
                    message = "create not allowed";
                    resource = null;
                }
lbl96:
                // 9 sources

                if (resource == null) break block62;
                resource.normalize();
                if (localSerializer == null) {
                    localSerializer = this.configuredSerializerName;
                }
                if (localSerializer != null) {
                    selector = null;
                    serializer = null;
                    oStream = null;
                    try {
                        selector = (ServiceSelector)this.manager.lookup(Serializer.ROLE + "Selector");
                        serializer = (Serializer)selector.select((Object)localSerializer);
                        oStream = ws.getOutputStream();
                        serializer.setOutputStream(oStream);
                        streamer = new DOMStreamer(serializer);
                        streamer.stream(resource);
                        var24_27 = null;
                        if (oStream == null) break block62;
                    }
                    catch (Throwable var23_37) {
                        block63: {
                            var24_28 = null;
                            if (oStream != null) {
                                oStream.flush();
                                try {
                                    oStream.close();
                                    failed = false;
                                    var27_31 = null;
                                    ** if (selector == null) goto lbl-1000
                                }
                                catch (Throwable var26_36) {
                                    var27_32 = null;
                                    if (selector != null) {
                                        selector.release((Object)serializer);
                                        this.manager.release((Object)selector);
                                    }
                                    throw var26_36;
                                }
lbl-1000:
                                // 1 sources

                                {
                                    selector.release((Object)serializer);
                                    this.manager.release((Object)selector);
                                }
lbl-1000:
                                // 2 sources

                                {
                                    break block63;
                                    catch (Throwable t) {
                                        if (this.getLogger().isDebugEnabled()) {
                                            this.getLogger().debug("FAIL (oStream.close) exception" + t, t);
                                        }
                                        throw new ProcessingException("Could not process your document.", t);
                                    }
                                }
                            }
                        }
                        throw var23_37;
                    }
                    oStream.flush();
                    try {
                        oStream.close();
                        failed = false;
                        var27_29 = null;
                        ** if (selector == null) goto lbl-1000
                    }
                    catch (Throwable var26_35) {
                        var27_30 = null;
                        if (selector != null) {
                            selector.release((Object)serializer);
                            this.manager.release((Object)selector);
                        }
                        throw var26_35;
                    }
lbl-1000:
                    // 1 sources

                    {
                        selector.release((Object)serializer);
                        this.manager.release((Object)selector);
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block62;
                        catch (Throwable t) {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("FAIL (oStream.close) exception" + t, t);
                            }
                            throw new ProcessingException("Could not process your document.", t);
                        }
                    }
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("ERROR no serializer");
                }
                message = "That source requires a serializer, please add the appropirate tag to your code.";
            }
            catch (DOMException de) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("FAIL exception: " + de, (Throwable)de);
                }
                message = "There was a problem manipulating your document: " + de;
            }
            catch (ServiceException ce) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("FAIL exception: " + (Object)ce, (Throwable)ce);
                }
                message = "There was a problem looking up a component: " + (Object)ce;
            }
            catch (SourceException se) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("FAIL exception: " + (Object)se, (Throwable)se);
                }
                message = "There was a problem resolving that source: [" + systemID + "] : " + (Object)se;
            }
            finally {
                this.resolver.release(source);
            }
        }
        result = failed != false ? "failed" : "success";
        action = "none";
        if (!failed) {
            action = exists != false ? "overwritten" : "new";
        }
        this.reportResult(localSerializer, tagname, message, target, result, action);
    }

    private void reportResult(String localSerializer, String tagname, String message, String target, String result, String action) throws SAXException {
        this.sendStartElementEvent(RESULT_ELEMENT);
        this.sendStartElementEvent(EXECUTION_ELEMENT);
        this.sendTextEvent(result);
        this.sendEndElementEvent(EXECUTION_ELEMENT);
        this.sendStartElementEvent(MESSAGE_ELEMENT);
        this.sendTextEvent(message);
        this.sendEndElementEvent(MESSAGE_ELEMENT);
        this.sendStartElementEvent(BEHAVIOUR_ELEMENT);
        this.sendTextEvent(tagname);
        this.sendEndElementEvent(BEHAVIOUR_ELEMENT);
        this.sendStartElementEvent(ACTION_ELEMENT);
        this.sendTextEvent(action);
        this.sendEndElementEvent(ACTION_ELEMENT);
        this.sendStartElementEvent(SOURCE_ELEMENT);
        this.sendTextEvent(target);
        this.sendEndElementEvent(SOURCE_ELEMENT);
        if (localSerializer != null) {
            this.sendStartElementEvent("serializer");
            this.sendTextEvent(localSerializer);
            this.sendEndElementEvent("serializer");
        }
        this.sendEndElementEvent(RESULT_ELEMENT);
    }

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this.xpathProcessor = (XPathProcessor)this.manager.lookup(XPathProcessor.ROLE);
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.xpathProcessor);
            this.xpathProcessor = null;
        }
    }
}

