/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml.dom;

import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DOMBuilder
extends AbstractXMLPipe {
    protected static final SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();
    protected Listener listener;
    protected DOMResult result;
    protected Node parentNode;

    public DOMBuilder() {
        this(null, null);
    }

    public DOMBuilder(Listener listener) {
        this(listener, null);
    }

    public DOMBuilder(Listener listener, Node parentNode) {
        this.listener = listener;
        try {
            TransformerHandler handler = factory.newTransformerHandler();
            this.setContentHandler(handler);
            this.setLexicalHandler(handler);
            this.parentNode = parentNode;
            this.result = parentNode != null ? new DOMResult(parentNode) : new DOMResult();
            handler.setResult(this.result);
        }
        catch (TransformerException local) {
            throw new CascadingRuntimeException("Fatal-Error: Unable to get transformer handler", (Throwable)local);
        }
    }

    public DOMBuilder(Node parentNode) {
        this(null, parentNode);
    }

    public void recycle() {
        super.recycle();
        try {
            TransformerHandler handler = factory.newTransformerHandler();
            this.setContentHandler(handler);
            this.setLexicalHandler(handler);
            this.result = this.parentNode != null ? new DOMResult(this.parentNode) : new DOMResult();
            handler.setResult(this.result);
        }
        catch (TransformerException local) {
            throw new CascadingRuntimeException("Fatal-Error: Unable to get transformer handler", (Throwable)local);
        }
    }

    public Document getDocument() {
        if (this.result == null || this.result.getNode() == null) {
            return null;
        }
        if (this.result.getNode().getNodeType() == 9) {
            return (Document)this.result.getNode();
        }
        return this.result.getNode().getOwnerDocument();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.notifyListener();
    }

    protected void notifyListener() throws SAXException {
        if (this.listener != null) {
            this.listener.notify(this.getDocument());
        }
    }

    public static interface Listener {
        public void notify(Document var1) throws SAXException;
    }
}

