/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.jci.ResourceStoreClassLoader;
import org.apache.commons.jci.compilers.JavaCompiler;
import org.apache.commons.jci.compilers.eclipse.EclipseJavaCompiler;
import org.apache.commons.jci.monitor.FilesystemAlterationListener;
import org.apache.commons.jci.monitor.FilesystemAlterationMonitor;
import org.apache.commons.jci.problems.ConsoleCompilationProblemHandler;
import org.apache.commons.jci.readers.FileResourceReader;
import org.apache.commons.jci.readers.ResourceReader;
import org.apache.commons.jci.stores.MemoryResourceStore;
import org.apache.commons.jci.stores.TransactionalResourceStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompilingClassLoader
extends ClassLoader {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jci$CompilingClassLoader == null ? (class$org$apache$commons$jci$CompilingClassLoader = CompilingClassLoader.class$("org.apache.commons.jci.CompilingClassLoader")) : class$org$apache$commons$jci$CompilingClassLoader));
    private final ClassLoader parent;
    private final File repository;
    private ClassLoader delegate;
    private final TransactionalResourceStore store;
    private final ResourceReader reader;
    private final JavaCompiler compiler;
    private final FilesystemAlterationMonitor fam;
    static /* synthetic */ Class class$org$apache$commons$jci$CompilingClassLoader;

    public CompilingClassLoader(ClassLoader pParent, File pRepository) {
        this(pParent, pRepository, new TransactionalResourceStore(new MemoryResourceStore()){

            public void onStart() {
            }

            public void onStop() {
            }
        });
    }

    public CompilingClassLoader(ClassLoader pParent, File pRepository, TransactionalResourceStore pStore) {
        super(pParent);
        this.parent = pParent;
        this.repository = pRepository;
        this.reader = new FileResourceReader(this.repository);
        this.store = pStore;
        this.compiler = new EclipseJavaCompiler();
        this.fam = new FilesystemAlterationMonitor();
        this.fam.addListener(new FilesystemAlterationListener(){
            private Collection created = new ArrayList();
            private Collection changed = new ArrayList();
            private Collection deleted = new ArrayList();

            public void onStart() {
                this.created.clear();
                this.changed.clear();
                this.deleted.clear();
                CompilingClassLoader.this.store.onStart();
            }

            public void onStop() {
                boolean reload = false;
                if (this.deleted.size() > 0) {
                    Iterator it = this.deleted.iterator();
                    while (it.hasNext()) {
                        File file = (File)it.next();
                        CompilingClassLoader.this.store.remove(CompilingClassLoader.clazzName(CompilingClassLoader.this.repository, file));
                    }
                    reload = true;
                }
                ArrayList compileables = new ArrayList();
                compileables.addAll(this.created);
                compileables.addAll(this.changed);
                String[] clazzes = new String[compileables.size()];
                if (compileables.size() > 0) {
                    int i = 0;
                    Iterator it = compileables.iterator();
                    while (it.hasNext()) {
                        File file = (File)it.next();
                        clazzes[i] = CompilingClassLoader.clazzName(CompilingClassLoader.this.repository, file);
                        ++i;
                    }
                    ConsoleCompilationProblemHandler problemHandler = new ConsoleCompilationProblemHandler();
                    CompilingClassLoader.this.compiler.compile(clazzes, CompilingClassLoader.this.reader, CompilingClassLoader.this.store, problemHandler);
                    log.debug((Object)(problemHandler.getErrorCount() + " errors, " + problemHandler.getWarningCount() + " warnings"));
                    if (problemHandler.getErrorCount() > 0) {
                        for (int j = 0; j < clazzes.length; ++j) {
                            CompilingClassLoader.this.store.remove(clazzes[j]);
                        }
                    }
                    reload = true;
                }
                CompilingClassLoader.this.store.onStop();
                if (reload) {
                    CompilingClassLoader.this.reload();
                }
            }

            public void onCreateFile(File file) {
                if (file.getName().endsWith(".java")) {
                    this.created.add(file);
                }
            }

            public void onChangeFile(File file) {
                if (file.getName().endsWith(".java")) {
                    this.changed.add(file);
                }
            }

            public void onDeleteFile(File file) {
                if (file.getName().endsWith(".java")) {
                    this.deleted.add(file);
                }
            }

            public void onCreateDirectory(File file) {
            }

            public void onChangeDirectory(File file) {
            }

            public void onDeleteDirectory(File file) {
            }
        }, this.repository);
        this.delegate = new ResourceStoreClassLoader(this.parent, this.store);
        Thread myThread = new Thread(this.fam);
        myThread.start();
    }

    private void reload() {
        log.debug((Object)"reloading");
        this.delegate = new ResourceStoreClassLoader(this.parent, this.store);
    }

    public static String clazzName(File base, File file) {
        int rootLength = base.getAbsolutePath().length();
        String absFileName = file.getAbsolutePath();
        String relFileName = absFileName.substring(rootLength + 1, absFileName.length() - ".java".length());
        String clazzName = relFileName.replace(File.separatorChar, '.');
        return clazzName;
    }

    public void clearAssertionStatus() {
        this.delegate.clearAssertionStatus();
    }

    public URL getResource(String name) {
        return this.delegate.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return this.delegate.getResourceAsStream(name);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.delegate.loadClass(name);
    }

    public void setClassAssertionStatus(String className, boolean enabled) {
        this.delegate.setClassAssertionStatus(className, enabled);
    }

    public void setDefaultAssertionStatus(boolean enabled) {
        this.delegate.setDefaultAssertionStatus(enabled);
    }

    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        this.delegate.setPackageAssertionStatus(packageName, enabled);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

