/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jci.ResourceStoreClassLoader;
import org.apache.commons.jci.monitor.FilesystemAlterationListener;
import org.apache.commons.jci.monitor.FilesystemAlterationMonitor;
import org.apache.commons.jci.readers.FileResourceReader;
import org.apache.commons.jci.readers.ResourceReader;
import org.apache.commons.jci.stores.MemoryResourceStore;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReloadingClassLoader
extends ClassLoader {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jci$ReloadingClassLoader == null ? (class$org$apache$commons$jci$ReloadingClassLoader = ReloadingClassLoader.class$("org.apache.commons.jci.ReloadingClassLoader")) : class$org$apache$commons$jci$ReloadingClassLoader));
    private final ClassLoader parent;
    private final File repository;
    private ClassLoader delegate;
    private final ResourceStore store;
    private final ResourceReader reader;
    private final FilesystemAlterationMonitor fam;
    static /* synthetic */ Class class$org$apache$commons$jci$ReloadingClassLoader;

    public ReloadingClassLoader(ClassLoader pParent, File pRepository) {
        this(pParent, pRepository, new MemoryResourceStore());
    }

    public ReloadingClassLoader(ClassLoader pParent, File pRepository, ResourceStore pStore) {
        super(pParent);
        this.parent = pParent;
        this.repository = pRepository;
        this.reader = new FileResourceReader(this.repository);
        this.store = pStore;
        this.fam = new FilesystemAlterationMonitor();
        this.fam.addListener(new FilesystemAlterationListener(){
            private Collection created = new ArrayList();
            private Collection changed = new ArrayList();
            private Collection deleted = new ArrayList();

            public void onStart() {
                this.created.clear();
                this.changed.clear();
                this.deleted.clear();
            }

            public void onStop() {
                File file;
                Iterator it;
                boolean reload = false;
                if (this.deleted.size() > 0) {
                    it = this.deleted.iterator();
                    while (it.hasNext()) {
                        file = (File)it.next();
                        ReloadingClassLoader.this.store.remove(ReloadingClassLoader.clazzName(ReloadingClassLoader.this.repository, file));
                    }
                    reload = true;
                }
                if (this.created.size() > 0) {
                    it = this.created.iterator();
                    while (it.hasNext()) {
                        file = (File)it.next();
                        try {
                            byte[] bytes = IOUtils.toByteArray((Reader)new FileReader(file));
                            ReloadingClassLoader.this.store.write(ReloadingClassLoader.clazzName(ReloadingClassLoader.this.repository, file), bytes);
                        }
                        catch (Exception e) {
                            log.error((Object)("could not load " + file), (Throwable)e);
                        }
                    }
                }
                if (this.changed.size() > 0) {
                    reload = true;
                }
                if (reload) {
                    ReloadingClassLoader.this.reload();
                }
            }

            public void onCreateFile(File file) {
                if (file.getName().endsWith(".class")) {
                    this.created.add(file);
                }
            }

            public void onChangeFile(File file) {
                if (file.getName().endsWith(".class")) {
                    this.changed.add(file);
                }
            }

            public void onDeleteFile(File file) {
                if (file.getName().endsWith(".class")) {
                    this.deleted.add(file);
                }
            }

            public void onCreateDirectory(File file) {
            }

            public void onChangeDirectory(File file) {
            }

            public void onDeleteDirectory(File file) {
            }
        }, this.repository);
        this.delegate = new ResourceStoreClassLoader(this.parent, this.store);
        Thread myThread = new Thread(this.fam);
        myThread.start();
    }

    private void reload() {
        log.debug((Object)"reloading");
        this.delegate = new ResourceStoreClassLoader(this.parent, this.store);
    }

    public static String clazzName(File base, File file) {
        int rootLength = base.getAbsolutePath().length();
        String absFileName = file.getAbsolutePath();
        String relFileName = absFileName.substring(rootLength + 1, absFileName.length() - ".java".length());
        String clazzName = relFileName.replace(File.separatorChar, '.');
        return clazzName;
    }

    public void clearAssertionStatus() {
        this.delegate.clearAssertionStatus();
    }

    public URL getResource(String name) {
        return this.delegate.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return this.delegate.getResourceAsStream(name);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.delegate.loadClass(name);
    }

    public void setClassAssertionStatus(String className, boolean enabled) {
        this.delegate.setClassAssertionStatus(className, enabled);
    }

    public void setDefaultAssertionStatus(boolean enabled) {
        this.delegate.setDefaultAssertionStatus(enabled);
    }

    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        this.delegate.setPackageAssertionStatus(packageName, enabled);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

