/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci;

import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ResourceStoreClassLoader
extends ClassLoader {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jci$ResourceStoreClassLoader == null ? (class$org$apache$commons$jci$ResourceStoreClassLoader = ResourceStoreClassLoader.class$("org.apache.commons.jci.ResourceStoreClassLoader")) : class$org$apache$commons$jci$ResourceStoreClassLoader));
    private final ResourceStore store;
    private final ClassLoader parent;
    static /* synthetic */ Class class$org$apache$commons$jci$ResourceStoreClassLoader;

    public ResourceStoreClassLoader(ClassLoader pParent, ResourceStore pStore) {
        super(pParent);
        this.parent = pParent;
        this.store = pStore;
    }

    private Class fastFindClass(String name) {
        byte[] clazzBytes = this.store.read(name);
        if (clazzBytes != null) {
            return this.defineClass(name, clazzBytes, 0, clazzBytes.length);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            clazz = this.fastFindClass(name);
            if (clazz == null) {
                ClassLoader parent = this.getParent();
                if (parent == null) throw new ClassNotFoundException(name);
                clazz = parent.loadClass(name);
            } else {
                log.debug((Object)("loaded from store: " + name));
            }
        }
        if (!resolve) return clazz;
        this.resolveClass(clazz);
        return clazz;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class clazz = this.fastFindClass(name);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

