/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.compilers.eclipse;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.jci.compilers.JavaCompiler;
import org.apache.commons.jci.problems.CompilationProblem;
import org.apache.commons.jci.problems.CompilationProblemHandler;
import org.apache.commons.jci.problems.ConsoleCompilationProblemHandler;
import org.apache.commons.jci.readers.FileResourceReader;
import org.apache.commons.jci.readers.ResourceReader;
import org.apache.commons.jci.stores.MemoryResourceStore;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;

public final class EclipseJavaCompiler
implements JavaCompiler {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jci$compilers$eclipse$EclipseJavaCompiler == null ? (class$org$apache$commons$jci$compilers$eclipse$EclipseJavaCompiler = EclipseJavaCompiler.class$("org.apache.commons.jci.compilers.eclipse.EclipseJavaCompiler")) : class$org$apache$commons$jci$compilers$eclipse$EclipseJavaCompiler));
    static /* synthetic */ Class class$org$apache$commons$jci$compilers$eclipse$EclipseJavaCompiler;

    public void compile(String[] clazzNames, final ResourceReader reader, final ResourceStore store, final CompilationProblemHandler problemHandler) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        settings.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "ignore");
        settings.put("org.eclipse.jdt.core.encoding", "UTF-8");
        settings.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        settings.put("org.eclipse.jdt.core.compiler.source", "1.4");
        settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
        HashSet<String> clazzIndex = new HashSet<String>();
        ICompilationUnit[] compilationUnits = new ICompilationUnit[clazzNames.length];
        for (int i = 0; i < compilationUnits.length; ++i) {
            String clazzName = clazzNames[i];
            compilationUnits[i] = new CompilationUnit(reader, clazzName);
            clazzIndex.add(clazzName);
            log.debug((Object)("compiling " + clazzName));
        }
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        INameEnvironment nameEnvironment = new INameEnvironment(){

            public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
                StringBuffer result = new StringBuffer();
                for (int i = 0; i < compoundTypeName.length; ++i) {
                    if (i != 0) {
                        result.append('.');
                    }
                    result.append(compoundTypeName[i]);
                }
                return this.findType(result.toString());
            }

            public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
                StringBuffer result = new StringBuffer();
                for (int i = 0; i < packageName.length; ++i) {
                    if (i != 0) {
                        result.append('.');
                    }
                    result.append(packageName[i]);
                }
                result.append('.');
                result.append(typeName);
                return this.findType(result.toString());
            }

            private NameEnvironmentAnswer findType(String clazzName) {
                byte[] clazzBytes = store.read(clazzName);
                if (clazzBytes != null) {
                    char[] fileName = clazzName.toCharArray();
                    try {
                        ClassFileReader classFileReader = new ClassFileReader(clazzBytes, fileName, true);
                        return new NameEnvironmentAnswer((IBinaryType)classFileReader);
                    }
                    catch (ClassFormatException e) {
                        e.printStackTrace();
                    }
                } else {
                    if (reader.isAvailable(clazzName.replace('.', '/') + ".java")) {
                        log.debug((Object)("compile " + clazzName));
                        CompilationUnit compilationUnit = new CompilationUnit(reader, clazzName);
                        return new NameEnvironmentAnswer((ICompilationUnit)compilationUnit);
                    }
                    String resourceName = clazzName.replace('.', '/') + ".class";
                    InputStream is = this.getClass().getClassLoader().getResourceAsStream(resourceName);
                    if (is != null) {
                        byte[] buffer = new byte[8192];
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(buffer.length);
                        try {
                            int count;
                            while ((count = is.read(buffer, 0, buffer.length)) > 0) {
                                baos.write(buffer, 0, count);
                            }
                            baos.flush();
                            clazzBytes = baos.toByteArray();
                            char[] fileName = clazzName.toCharArray();
                            ClassFileReader classFileReader = new ClassFileReader(clazzBytes, fileName, true);
                            return new NameEnvironmentAnswer((IBinaryType)classFileReader);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                return null;
            }

            private boolean isPackage(String clazzName) {
                String resourceName = clazzName.replace('.', '/') + ".class";
                InputStream is = this.getClass().getClassLoader().getResourceAsStream(resourceName);
                boolean result = is == null;
                return result;
            }

            public boolean isPackage(char[][] parentPackageName, char[] packageName) {
                StringBuffer result = new StringBuffer();
                if (parentPackageName != null) {
                    for (int i = 0; i < parentPackageName.length; ++i) {
                        if (i != 0) {
                            result.append('.');
                        }
                        result.append(parentPackageName[i]);
                    }
                }
                if (Character.isUpperCase(packageName[0])) {
                    return false;
                }
                if (parentPackageName != null && parentPackageName.length > 0) {
                    result.append('.');
                }
                result.append(packageName);
                return this.isPackage(result.toString());
            }

            public void cleanup() {
            }
        };
        ICompilerRequestor compilerRequestor = new ICompilerRequestor(){

            public void acceptResult(CompilationResult result) {
                try {
                    if (result.hasProblems()) {
                        if (problemHandler != null) {
                            IProblem[] problems = result.getProblems();
                            for (int i = 0; i < problems.length; ++i) {
                                IProblem problem = problems[i];
                                problemHandler.handle(new CompilationProblem(problem.getID(), new String(problem.getOriginatingFileName()), problem.getMessage(), problem.getSourceLineNumber(), problem.getSourceLineNumber(), problem.isError()));
                            }
                        }
                    } else {
                        ClassFile[] clazzFiles = result.getClassFiles();
                        for (int i = 0; i < clazzFiles.length; ++i) {
                            ClassFile clazzFile = clazzFiles[i];
                            char[][] compoundName = clazzFile.getCompoundName();
                            StringBuffer clazzName = new StringBuffer();
                            for (int j = 0; j < compoundName.length; ++j) {
                                if (j != 0) {
                                    clazzName.append('.');
                                }
                                clazzName.append(compoundName[j]);
                            }
                            store.write(clazzName.toString(), clazzFile.getBytes());
                        }
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        };
        Compiler compiler = new Compiler(nameEnvironment, policy, settings, compilerRequestor, (IProblemFactory)problemFactory);
        compiler.compile(compilationUnits);
    }

    public static void main(String[] args) throws Exception {
        EclipseJavaCompiler compiler = new EclipseJavaCompiler();
        ConsoleCompilationProblemHandler problemHandler = new ConsoleCompilationProblemHandler();
        compiler.compile(args, new FileResourceReader("classes"), new MemoryResourceStore(), problemHandler);
        log.debug((Object)(problemHandler.getErrorCount() + " errors, " + problemHandler.getWarningCount() + " warnings"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    final class CompilationUnit
    implements ICompilationUnit {
        private final String clazzName;
        private final String fileName;
        private final char[] typeName;
        private final char[][] packageName;
        private final ResourceReader reader;

        CompilationUnit(ResourceReader pReader, String pClazzName) {
            this.reader = pReader;
            this.clazzName = pClazzName;
            this.fileName = StringUtils.replaceChars((String)this.clazzName, (char)'.', (char)'/') + ".java";
            int dot = this.clazzName.lastIndexOf(46);
            this.typeName = dot > 0 ? this.clazzName.substring(dot + 1).toCharArray() : this.clazzName.toCharArray();
            StringTokenizer izer = new StringTokenizer(this.clazzName, ".");
            this.packageName = new char[izer.countTokens() - 1][];
            for (int i = 0; i < this.packageName.length; ++i) {
                this.packageName[i] = izer.nextToken().toCharArray();
            }
        }

        public char[] getFileName() {
            return this.fileName.toCharArray();
        }

        public char[] getContents() {
            return this.reader.getContent(this.fileName);
        }

        public char[] getMainTypeName() {
            return this.typeName;
        }

        public char[][] getPackageName() {
            return this.packageName;
        }
    }
}

