/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.property;

import java.util.Vector;
import net.sf.antcontrib.property.AbstractPropertySetterTask;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.RegularExpression;
import org.apache.tools.ant.types.Substitution;
import org.apache.tools.ant.util.regexp.Regexp;

public class RegexTask
extends AbstractPropertySetterTask {
    private String input;
    private RegularExpression regexp;
    private String select;
    private Substitution replace;
    private String defaultValue;
    private boolean caseSensitive = true;
    private boolean global = true;

    public void setInput(String string) {
        this.input = string;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public void setRegexp(String string) {
        if (this.regexp != null) {
            throw new BuildException("Cannot specify more than one regular expression");
        }
        this.regexp = new RegularExpression();
        this.regexp.setPattern(string);
    }

    public RegularExpression createRegexp() {
        if (this.regexp != null) {
            throw new BuildException("Cannot specify more than one regular expression");
        }
        this.regexp = new RegularExpression();
        return this.regexp;
    }

    public void setReplace(String string) {
        if (this.replace != null) {
            throw new BuildException("Cannot specify more than one replace expression");
        }
        if (this.select != null) {
            throw new BuildException("You cannot specify both a select and replace expression");
        }
        this.replace = new Substitution();
        this.replace.setExpression(string);
    }

    public Substitution createReplace() {
        if (this.replace != null) {
            throw new BuildException("Cannot specify more than one replace expression");
        }
        if (this.select != null) {
            throw new BuildException("You cannot specify both a select and replace expression");
        }
        this.replace = new Substitution();
        return this.replace;
    }

    public void setSelect(String string) {
        if (this.replace != null) {
            throw new BuildException("You cannot specify both a select and replace expression");
        }
        this.select = string;
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public void setGlobal(boolean bl) {
        this.global = bl;
    }

    protected String doReplace() throws BuildException {
        if (this.replace == null) {
            throw new BuildException("No replace expression specified.");
        }
        int n = 0;
        if (!this.caseSensitive) {
            n |= 0x100;
        }
        if (this.global) {
            n |= 0x10;
        }
        Regexp regexp = this.regexp.getRegexp(this.project);
        String string = null;
        if (regexp.matches(this.input, n)) {
            string = regexp.substitute(this.input, this.replace.getExpression(this.getProject()), n);
        }
        if (string == null) {
            string = this.defaultValue;
        }
        return string;
    }

    protected String doSelect() throws BuildException {
        int n = 0;
        if (!this.caseSensitive) {
            n |= 0x100;
        }
        Regexp regexp = this.regexp.getRegexp(this.project);
        String string = this.select;
        Vector vector = regexp.getGroups(this.input, n);
        if (vector != null && vector.size() > 0) {
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                String string2 = (String)vector.elementAt(n3);
                RegularExpression regularExpression = null;
                regularExpression = new RegularExpression();
                regularExpression.setPattern("\\\\" + n3);
                string = regularExpression.getRegexp(this.project).substitute(string, string2, 0);
                ++n3;
            }
        } else {
            string = null;
        }
        return string;
    }

    protected void validate() {
        super.validate();
        if (this.regexp == null) {
            throw new BuildException("No match expression specified.");
        }
        if (this.replace == null && this.select == null) {
            throw new BuildException("You must specify either a replace or select expression");
        }
    }

    public void execute() throws BuildException {
        this.validate();
        String string = this.input;
        string = this.replace != null ? this.doReplace() : this.doSelect();
        if (string != null) {
            this.setPropertyValue(string);
        }
    }
}

