/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.walls;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.types.FileSet;

public class Package {
    private String name;
    private String pack;
    private String failureReason = null;
    private String[] depends;
    private Vector dependsPack = new Vector();
    private FileSet set = new FileSet();

    public void setName(String string) {
        this.name = string;
    }

    public void setPackage(String string) {
        this.pack = string;
    }

    public void setDepends(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t");
        this.depends = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.depends[n] = stringTokenizer.nextToken();
            ++n;
        }
    }

    public String getName() {
        return this.name;
    }

    public String[] getDepends() {
        return this.depends;
    }

    public FileSet getExcludesFileSet(Project project, Location location) throws BuildException {
        if (this.failureReason != null) {
            throw new BuildException(this.failureReason, location);
        }
        if (this.pack.indexOf("/") != -1 || this.pack.indexOf("\\") != -1) {
            throw new BuildException("A package name cannot contain '\\' or '/' like package=" + this.pack + "\nIt must look like biz.xsoftware.* for example", location);
        }
        String string = ProjectHelper.replaceProperties((Project)project, (String)this.pack);
        if ((string = string.replace('.', File.separatorChar)).endsWith("**")) {
            string = string + "/*.java";
        } else if (string.endsWith("*")) {
            string = string + ".java";
        } else {
            throw new RuntimeException("Please report this bug");
        }
        this.set.setExcludes(string);
        int n = 0;
        while (n < this.dependsPack.size()) {
            String string2 = (String)this.dependsPack.elementAt(n);
            string2 = ProjectHelper.replaceProperties((Project)project, (String)string2);
            string2 = string2.replace('.', File.separatorChar);
            this.set.setExcludes(string2);
            ++n;
        }
        return this.set;
    }

    public void addExcludesElement(String string) {
        this.dependsPack.addElement(string);
    }

    public String getPackage() {
        return this.pack;
    }

    public void setFaultReason(String string) {
        this.failureReason = string;
    }
}

