/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.user.provider.hibernate.impl;

import com.opensymphony.user.provider.hibernate.dao.HibernateQueries;
import com.opensymphony.user.provider.hibernate.dao.HibernateUserDAO;
import com.opensymphony.user.provider.hibernate.dao.SessionManager;
import com.opensymphony.user.provider.hibernate.entity.HibernateUser;
import java.io.Serializable;
import java.util.List;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.type.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HibernateUserDAOImpl
implements HibernateUserDAO {
    protected Log log = LogFactory.getLog((String)(class$com$opensymphony$user$provider$hibernate$impl$HibernateUserDAOImpl == null ? (class$com$opensymphony$user$provider$hibernate$impl$HibernateUserDAOImpl = HibernateUserDAOImpl.class$("com.opensymphony.user.provider.hibernate.impl.HibernateUserDAOImpl")) : class$com$opensymphony$user$provider$hibernate$impl$HibernateUserDAOImpl).getName());
    private SessionManager sessionManager;
    static /* synthetic */ Class class$com$opensymphony$user$provider$hibernate$impl$HibernateUserDAOImpl;

    public HibernateUserDAOImpl(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public int deleteUserByUsername(String username) {
        int numberOfUsersDeleted = 0;
        Session session = null;
        try {
            try {
                session = this.sessionManager.getSession();
                numberOfUsersDeleted = session.delete(HibernateQueries.USER_BY_USERNAME, (Object)username, (Type)Hibernate.STRING);
            }
            catch (HibernateException he) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Unable to find user with username " + username), (Throwable)he);
                }
                Object var6_5 = null;
                this.sessionManager.closeSession(session);
            }
            Object var6_4 = null;
            this.sessionManager.closeSession(session);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.sessionManager.closeSession(session);
            throw throwable;
        }
        return numberOfUsersDeleted;
    }

    public HibernateUser findUserByUsername(String username) {
        HibernateUser user = null;
        Session session = null;
        try {
            block5: {
                try {
                    session = this.sessionManager.getSession();
                    List ret = session.find(HibernateQueries.USER_BY_USERNAME, (Object)username, (Type)Hibernate.STRING);
                    if (ret.size() <= 0) break block5;
                    user = (HibernateUser)ret.get(0);
                }
                catch (HibernateException he) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Unable to find user with username " + username), (Throwable)he);
                    }
                    user = null;
                    Object var6_7 = null;
                    this.sessionManager.closeSession(session);
                }
            }
            Object var6_6 = null;
            this.sessionManager.closeSession(session);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.sessionManager.closeSession(session);
            throw throwable;
        }
        return user;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HibernateUser findUserByUsernameAndGroupname(String userName, String groupName) {
        Session session = null;
        HibernateUser user = null;
        try {
            try {
                session = this.sessionManager.getSession();
                List results = session.find(HibernateQueries.USER_BY_USERNAME_AND_GROUPNAME, new Object[]{userName, groupName}, new Type[]{Hibernate.STRING, Hibernate.STRING});
                if (results.size() == 0) {
                    HibernateUser hibernateUser = null;
                    Object var8_8 = null;
                    this.sessionManager.closeSession(session);
                    return hibernateUser;
                }
                user = (HibernateUser)results.get(0);
            }
            catch (HibernateException he) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Unable to find user with username " + userName + " and groupname " + groupName), (Throwable)he);
                }
                user = null;
                Object var8_10 = null;
                this.sessionManager.closeSession(session);
                return user;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.sessionManager.closeSession(session);
            throw throwable;
        }
        Object var8_9 = null;
        this.sessionManager.closeSession(session);
        return user;
    }

    public List findUsers() {
        List users = null;
        Session session = null;
        try {
            try {
                session = this.sessionManager.getSession();
                users = session.find(HibernateQueries.ALL_USERS);
            }
            catch (HibernateException he) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"HibernateException retrieving all groups.", (Throwable)he);
                }
                users = null;
                Object var5_4 = null;
                this.sessionManager.closeSession(session);
            }
            Object var5_3 = null;
            this.sessionManager.closeSession(session);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.sessionManager.closeSession(session);
            throw throwable;
        }
        return users;
    }

    public boolean saveUser(HibernateUser user) {
        boolean result = false;
        Serializable id = null;
        Session session = null;
        try {
            try {
                session = this.sessionManager.getSession();
                id = session.save((Object)user);
                result = id != null;
            }
            catch (HibernateException he) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"HibernateException caught saving");
                }
                result = false;
                Object var7_6 = null;
                this.sessionManager.flushCloseSession(session);
            }
            Object var7_5 = null;
            this.sessionManager.flushCloseSession(session);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.sessionManager.flushCloseSession(session);
            throw throwable;
        }
        return result;
    }

    public boolean updateUser(HibernateUser user) {
        boolean result = false;
        Session session = null;
        try {
            try {
                session = this.sessionManager.getSession();
                session.saveOrUpdate((Object)user);
                result = true;
            }
            catch (HibernateException he) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Unable to update user with username " + user.getName()), (Throwable)he);
                }
                result = false;
                Object var6_5 = null;
                this.sessionManager.flushCloseSession(session);
            }
            Object var6_4 = null;
            this.sessionManager.flushCloseSession(session);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.sessionManager.flushCloseSession(session);
            throw throwable;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

