/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.user.provider.jdbc;

import com.opensymphony.user.provider.AccessProvider;
import com.opensymphony.user.provider.jdbc.BaseJDBCProvider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCAccessProvider
extends BaseJDBCProvider
implements AccessProvider {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$user$provider$jdbc$JDBCAccessProvider == null ? (class$com$opensymphony$user$provider$jdbc$JDBCAccessProvider = JDBCAccessProvider.class$("com.opensymphony.user.provider.jdbc.JDBCAccessProvider")) : class$com$opensymphony$user$provider$jdbc$JDBCAccessProvider));
    static /* synthetic */ Class class$com$opensymphony$user$provider$jdbc$JDBCAccessProvider;

    public boolean addToGroup(String username, String groupname) {
        boolean addedToGroup = false;
        try {
            Connection conn = this.ds.getConnection();
            PreparedStatement ps = conn.prepareStatement("INSERT INTO " + this.membershipTable + " (" + this.userName + ", " + this.groupName + ") VALUES (?, ?)");
            ps.setString(1, username);
            ps.setString(2, groupname);
            ps.executeUpdate();
            addedToGroup = true;
            ps.close();
            conn.close();
        }
        catch (SQLException e) {
            log.fatal((Object)("Could not add user [" + username + "] to group [" + groupname + "]"), (Throwable)e);
        }
        return addedToGroup;
    }

    public boolean create(String name) {
        boolean created = false;
        try {
            Connection conn = this.ds.getConnection();
            PreparedStatement ps = conn.prepareStatement("INSERT INTO " + this.groupTable + " (" + this.groupName + ") VALUES (?)");
            ps.setString(1, name);
            try {
                ps.executeUpdate();
                created = true;
            }
            catch (SQLException e) {
                log.warn((Object)("Group [" + name + "] must already exist"), (Throwable)e);
            }
            ps.close();
            conn.close();
        }
        catch (SQLException e) {
            log.fatal((Object)("Could not insert [" + name + "] into groups"), (Throwable)e);
        }
        return created;
    }

    public boolean handles(String name) {
        boolean handles = false;
        try {
            Connection conn = this.ds.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT " + this.userName + " FROM " + this.userTable + " WHERE " + this.userName + " = ?");
            ps.setString(1, name);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                handles = true;
            }
            rs.close();
            ps.close();
            if (!handles) {
                ps = conn.prepareStatement("SELECT " + this.groupName + " FROM " + this.groupTable + " WHERE " + this.groupName + " = ?");
                ps.setString(1, name);
                rs = ps.executeQuery();
                handles = rs.next();
                rs.close();
                ps.close();
            }
            conn.close();
        }
        catch (SQLException e) {
            log.fatal((Object)("Could not see if [" + name + "] is handled"), (Throwable)e);
        }
        return handles;
    }

    public boolean inGroup(String username, String groupname) {
        boolean inGroup = false;
        try {
            Connection conn = this.ds.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + this.membershipTable + " WHERE " + this.userName + " = ? AND " + this.groupName + " = ?");
            ps.setString(1, username);
            ps.setString(2, groupname);
            ResultSet rs = ps.executeQuery();
            inGroup = rs.next();
            rs.close();
            ps.close();
            conn.close();
        }
        catch (SQLException e) {
            log.fatal((Object)("Could not determine if user [" + username + "] is in group [" + groupname + "]"), (Throwable)e);
        }
        return inGroup;
    }

    public List list() {
        ArrayList<String> groups = new ArrayList<String>();
        try {
            Connection conn = this.ds.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT " + this.groupName + " FROM " + this.groupTable + " ORDER BY " + this.groupName);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                groups.add(rs.getString(1));
            }
            rs.close();
            ps.close();
            conn.close();
        }
        catch (SQLException e) {
            log.fatal((Object)"Could not list groups", (Throwable)e);
        }
        return groups;
    }

    public List listGroupsContainingUser(String username) {
        ArrayList<String> groups = new ArrayList<String>();
        try {
            Connection conn = this.ds.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT " + this.membershipGroupName + " FROM " + this.membershipTable + " WHERE " + this.membershipUserName + " = ?");
            ps.setString(1, username);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                groups.add(rs.getString(1));
            }
            rs.close();
            ps.close();
            conn.close();
        }
        catch (SQLException e) {
            log.fatal((Object)("Could not list groups containing user [" + username + "]"), (Throwable)e);
        }
        return groups;
    }

    public List listUsersInGroup(String groupname) {
        ArrayList<String> users = new ArrayList<String>();
        try {
            Connection conn = this.ds.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT " + this.membershipUserName + " FROM " + this.membershipTable + " WHERE " + this.membershipGroupName + " = ?");
            ps.setString(1, groupname);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                users.add(rs.getString(1));
            }
            rs.close();
            ps.close();
            conn.close();
        }
        catch (SQLException e) {
            log.fatal((Object)("Could not list users in group [" + groupname + "]"), (Throwable)e);
        }
        return users;
    }

    public boolean remove(String name) {
        boolean removed = false;
        try {
            Connection conn = this.ds.getConnection();
            PreparedStatement ps = conn.prepareStatement("DELETE FROM " + this.membershipTable + " WHERE " + this.membershipGroupName + " = ?");
            ps.setString(1, name);
            ps.executeUpdate();
            ps.close();
            ps = conn.prepareStatement("DELETE FROM " + this.groupTable + " WHERE " + this.groupName + " = ?");
            ps.setString(1, name);
            int rows = ps.executeUpdate();
            if (rows == 1) {
                removed = true;
            }
            ps.close();
            conn.close();
        }
        catch (SQLException e) {
            log.fatal((Object)("Could not remove group [" + name + "]"), (Throwable)e);
        }
        return removed;
    }

    public boolean removeFromGroup(String username, String groupname) {
        boolean removedFromGroup = false;
        try {
            Connection conn = this.ds.getConnection();
            PreparedStatement ps = conn.prepareStatement("DELETE FROM " + this.membershipTable + " WHERE " + this.userName + " = ? AND " + this.groupName + " =?");
            ps.setString(1, username);
            ps.setString(2, groupname);
            int rows = ps.executeUpdate();
            if (rows == 1) {
                removedFromGroup = true;
            }
            ps.close();
            conn.close();
        }
        catch (SQLException e) {
            log.fatal((Object)("Could not detele user [" + username + "] from group [" + groupname + "]"), (Throwable)e);
        }
        return removedFromGroup;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

