/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.user.provider.ldap;

import com.opensymphony.user.Entity;
import com.opensymphony.user.UserManager;
import com.opensymphony.user.provider.CredentialsProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LDAPCredentialsProvider
implements CredentialsProvider {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$user$provider$ldap$LDAPCredentialsProvider == null ? (class$com$opensymphony$user$provider$ldap$LDAPCredentialsProvider = LDAPCredentialsProvider.class$("com.opensymphony.user.provider.ldap.LDAPCredentialsProvider")) : class$com$opensymphony$user$provider$ldap$LDAPCredentialsProvider));
    private static HashMap cache = new HashMap();
    private Hashtable env;
    private String searchBase;
    private String uidSearchName;
    private long timeout;
    static /* synthetic */ Class class$com$opensymphony$user$provider$ldap$LDAPCredentialsProvider;

    public boolean authenticate(String name, String password) {
        if (password == null || "".equals(password)) {
            return false;
        }
        TimeAndPassword tp = (TimeAndPassword)cache.get(name);
        if (tp != null && tp.password.equals(password) && tp.time > System.currentTimeMillis()) {
            return true;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"LDAPCredentialsProvider.authenticate");
            }
            InitialDirContext ctx = new InitialDirContext(this.env);
            StringBuffer filterBuffer = new StringBuffer();
            filterBuffer.append(this.uidSearchName);
            filterBuffer.append("=");
            filterBuffer.append(name);
            String[] attrIDs = new String[]{this.uidSearchName};
            SearchControls ctls = new SearchControls();
            ctls.setReturningAttributes(attrIDs);
            ctls.setSearchScope(2);
            NamingEnumeration<SearchResult> results = ctx.search(this.searchBase, filterBuffer.toString(), ctls);
            StringBuffer dnBuffer = new StringBuffer();
            if (results != null && results.hasMore()) {
                SearchResult sr = results.next();
                dnBuffer.append(sr.getName());
                dnBuffer.append(",");
                dnBuffer.append(this.searchBase);
                ctx.removeFromEnvironment("java.naming.security.principal");
                ctx.removeFromEnvironment("java.naming.security.credentials");
                ctx.addToEnvironment("java.naming.security.principal", dnBuffer.toString());
                ctx.addToEnvironment("java.naming.security.credentials", password);
                ctls = new SearchControls();
                ctls.setReturningAttributes(new String[0]);
                ctls.setSearchScope(0);
                NamingEnumeration<SearchResult> authResults = ctx.search(dnBuffer.toString(), filterBuffer.toString(), ctls);
                cache.put(name, new TimeAndPassword(System.currentTimeMillis() + this.timeout, password));
                return true;
            }
        }
        catch (NamingException ne) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Couldn't find the user in LDAP server, trying other Credential Providers");
        }
        Collection credentialsProviders = UserManager.getInstance().getCredentialsProviders();
        Iterator iterator = credentialsProviders.iterator();
        while (iterator.hasNext()) {
            CredentialsProvider provider = (CredentialsProvider)iterator.next();
            boolean isLDAP = provider instanceof LDAPCredentialsProvider;
            if (isLDAP || !provider.handles(name)) continue;
            log.debug((Object)("Seeing if " + provider.getClass().getName() + " authenticates()"));
            boolean result = provider.authenticate(name, password);
            if (result) {
                cache.put(name, new TimeAndPassword(System.currentTimeMillis() + this.timeout, password));
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean changePassword(String name, String password) {
        Collection credentialsProviders = UserManager.getInstance().getCredentialsProviders();
        Iterator iterator = credentialsProviders.iterator();
        while (iterator.hasNext()) {
            CredentialsProvider provider = (CredentialsProvider)iterator.next();
            boolean isLDAP = provider instanceof LDAPCredentialsProvider;
            if (isLDAP || !provider.handles(name)) continue;
            return provider.changePassword(name, password);
        }
        return false;
    }

    public boolean create(String name) {
        return false;
    }

    public void flushCaches() {
        cache = new HashMap();
    }

    public boolean handles(String name) {
        TimeAndPassword tp;
        if (log.isDebugEnabled()) {
            log.debug((Object)"LDAPCredentialsProvider.handles");
        }
        if ((tp = (TimeAndPassword)cache.get(name)) != null && tp.time > System.currentTimeMillis()) {
            return true;
        }
        Collection credentialsProviders = UserManager.getInstance().getCredentialsProviders();
        boolean handles = false;
        Iterator iterator = credentialsProviders.iterator();
        while (iterator.hasNext()) {
            CredentialsProvider provider = (CredentialsProvider)iterator.next();
            boolean isLDAP = provider instanceof LDAPCredentialsProvider;
            if (isLDAP || !provider.handles(name)) continue;
            handles = true;
            break;
        }
        return handles;
    }

    public boolean init(Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"LDAPCredentialsProvider.init");
        }
        this.env = new Hashtable<Object, Object>(properties);
        this.env.put("java.naming.security.authentication", "simple");
        this.searchBase = properties.getProperty("searchBase");
        this.uidSearchName = properties.getProperty("uidSearchName");
        try {
            this.timeout = Long.parseLong(properties.getProperty("cacheTimeout"));
        }
        catch (NumberFormatException e) {
            this.timeout = 1800000L;
        }
        return true;
    }

    public List list() {
        return Collections.EMPTY_LIST;
    }

    public boolean load(String name, Entity.Accessor accessor) {
        Collection credentialsProviders = UserManager.getInstance().getCredentialsProviders();
        Iterator iterator = credentialsProviders.iterator();
        while (iterator.hasNext()) {
            CredentialsProvider provider = (CredentialsProvider)iterator.next();
            boolean isLDAP = provider instanceof LDAPCredentialsProvider;
            if (isLDAP || !provider.handles(name)) continue;
            return provider.load(name, accessor);
        }
        return true;
    }

    public boolean remove(String name) {
        Collection credentialsProviders = UserManager.getInstance().getCredentialsProviders();
        Iterator iterator = credentialsProviders.iterator();
        while (iterator.hasNext()) {
            CredentialsProvider provider = (CredentialsProvider)iterator.next();
            boolean isLDAP = provider instanceof LDAPCredentialsProvider;
            if (isLDAP || !provider.handles(name)) continue;
            return provider.remove(name);
        }
        return false;
    }

    public boolean store(String name, Entity.Accessor accessor) {
        Collection credentialsProviders = UserManager.getInstance().getCredentialsProviders();
        Iterator iterator = credentialsProviders.iterator();
        while (iterator.hasNext()) {
            CredentialsProvider provider = (CredentialsProvider)iterator.next();
            boolean isLDAP = provider instanceof LDAPCredentialsProvider;
            if (isLDAP || !provider.handles(name)) continue;
            return provider.store(name, accessor);
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TimeAndPassword {
        public String password;
        public long time;

        public TimeAndPassword(long time, String password) {
            this.time = time;
            this.password = password;
        }
    }
}

