/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Stack;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.search.LuceneCocoonHelper;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.commons.lang.BooleanUtils;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class LuceneIndexTransformer
extends AbstractTransformer
implements CacheableProcessingComponent,
Configurable,
Contextualizable {
    public static final String ANALYZER_CLASSNAME_CONFIG = "analyzer-classname";
    public static final String ANALYZER_CLASSNAME_PARAMETER = "analyzer-classname";
    public static final String ANALYZER_CLASSNAME_DEFAULT = "org.apache.lucene.analysis.standard.StandardAnalyzer";
    public static final String DIRECTORY_CONFIG = "directory";
    public static final String DIRECTORY_PARAMETER = "directory";
    public static final String DIRECTORY_DEFAULT = "index";
    public static final String MERGE_FACTOR_CONFIG = "merge-factor";
    public static final String MERGE_FACTOR_PARAMETER = "merge-factor";
    public static final int MERGE_FACTOR_DEFAULT = 20;
    public static final String LUCENE_URI = "http://apache.org/cocoon/lucene/1.0";
    public static final String LUCENE_QUERY_ELEMENT = "index";
    public static final String LUCENE_QUERY_ANALYZER_ATTRIBUTE = "analyzer";
    public static final String LUCENE_QUERY_DIRECTORY_ATTRIBUTE = "directory";
    public static final String LUCENE_QUERY_CREATE_ATTRIBUTE = "create";
    public static final String LUCENE_QUERY_MERGE_FACTOR_ATTRIBUTE = "merge-factor";
    public static final String LUCENE_DOCUMENT_ELEMENT = "document";
    public static final String LUCENE_DOCUMENT_URL_ATTRIBUTE = "url";
    public static final String LUCENE_ELEMENT_ATTR_TO_TEXT_ATTRIBUTE = "text-attr";
    public static final String LUCENE_ELEMENT_ATTR_STORE_VALUE = "store";
    public static final String LUCENE_ELAPSED_TIME_ATTRIBUTE = "elapsed-time";
    public static final String CDATA = "CDATA";
    private static final int STATE_GROUND = 0;
    private static final int STATE_QUERY = 1;
    private static final int STATE_DOCUMENT = 2;
    protected File workDir = null;
    private IndexerConfiguration configureConfiguration;
    private IndexerConfiguration setupConfiguration;
    private IndexerConfiguration queryConfiguration;
    private int processing;
    private boolean createIndex = false;
    private IndexWriter writer;
    private StringBuffer bodyText;
    private Document bodyDocument;
    private String bodyDocumentURL;
    private Stack elementStack = new Stack();
    private AttributesImpl documentAttributes;
    private long documentStartTime;

    private static String uid(String url) {
        return url.replace('/', '\u0000');
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.configureConfiguration = new IndexerConfiguration(conf.getChild("analyzer-classname").getValue(ANALYZER_CLASSNAME_DEFAULT), conf.getChild("directory").getValue("index"), conf.getChild("merge-factor").getValueAsInteger(20));
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.setupConfiguration = new IndexerConfiguration(parameters.getParameter("analyzer-classname", this.configureConfiguration.analyzerClassname), parameters.getParameter("directory", this.configureConfiguration.indexDirectory), parameters.getParameterAsInteger("merge-factor", this.configureConfiguration.mergeFactor));
    }

    public void contextualize(Context context) throws ContextException {
        this.workDir = (File)context.get((Object)"work-directory");
    }

    public void recycle() {
        this.processing = 0;
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.writer = null;
        }
        this.bodyText = null;
        this.bodyDocument = null;
        this.bodyDocumentURL = null;
        this.elementStack.clear();
        super.recycle();
    }

    public Serializable getKey() {
        return "1";
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.processing == 0) {
            super.startPrefixMapping(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.processing == 0) {
            super.endPrefixMapping(prefix);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.processing == 0) {
            if (LUCENE_URI.equals(namespaceURI) && "index".equals(localName)) {
                String sCreate = atts.getValue(LUCENE_QUERY_CREATE_ATTRIBUTE);
                this.createIndex = BooleanUtils.toBoolean((String)sCreate);
                String analyzerClassname = atts.getValue(LUCENE_QUERY_ANALYZER_ATTRIBUTE);
                String indexDirectory = atts.getValue("directory");
                String mergeFactor = atts.getValue("merge-factor");
                this.queryConfiguration = new IndexerConfiguration(analyzerClassname != null ? analyzerClassname : this.setupConfiguration.analyzerClassname, indexDirectory != null ? indexDirectory : this.setupConfiguration.indexDirectory, mergeFactor != null ? Integer.parseInt(mergeFactor) : this.setupConfiguration.mergeFactor);
                if (!this.createIndex) {
                    try {
                        IndexReader reader = this.openReader();
                        reader.close();
                    }
                    catch (IOException ioe) {
                        this.createIndex = true;
                    }
                }
                super.startElement(namespaceURI, localName, qName, atts);
                this.processing = 1;
                return;
            }
            super.startElement(namespaceURI, localName, qName, atts);
            return;
        }
        if (this.processing == 1) {
            if (!LUCENE_URI.equals(namespaceURI) || !LUCENE_DOCUMENT_ELEMENT.equals(localName)) throw new SAXException("<lucene:index> element can contain only <lucene:document> elements!");
            this.bodyDocumentURL = atts.getValue(LUCENE_DOCUMENT_URL_ATTRIBUTE);
            if (this.bodyDocumentURL == null) {
                throw new SAXException("<lucene:document> must have @url attribute");
            }
            this.documentStartTime = System.currentTimeMillis();
            this.documentAttributes = new AttributesImpl(atts);
            this.bodyText = new StringBuffer();
            this.bodyDocument = new Document();
            this.elementStack.clear();
            this.processing = 2;
            return;
        } else {
            if (this.processing != 2) return;
            this.elementStack.push(new IndexHelperField(localName, new AttributesImpl(atts)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.processing == 1) {
            if (!LUCENE_URI.equals(namespaceURI) || !"index".equals(localName)) throw new SAXException("</lucene:index> was expected!");
            try {
                if (this.writer == null) {
                    this.openWriter();
                }
                this.writer.optimize();
                this.writer.close();
                this.writer = null;
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
            super.endElement(namespaceURI, localName, qName);
            this.processing = 0;
            return;
        }
        if (this.processing == 2) {
            boolean store;
            if (LUCENE_URI.equals(namespaceURI) && LUCENE_DOCUMENT_ELEMENT.equals(localName)) {
                this.bodyDocument.add(Field.UnStored((String)"body", (String)this.bodyText.toString()));
                this.bodyText = null;
                this.bodyDocument.add(Field.UnIndexed((String)LUCENE_DOCUMENT_URL_ATTRIBUTE, (String)this.bodyDocumentURL));
                this.bodyDocument.add(new Field("uid", LuceneIndexTransformer.uid(this.bodyDocumentURL), false, true, false));
                try {
                    this.reindexDocument();
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
                this.bodyDocumentURL = null;
                long elapsedTime = System.currentTimeMillis() - this.documentStartTime;
                this.documentAttributes.addAttribute("", LUCENE_ELAPSED_TIME_ATTRIBUTE, LUCENE_ELAPSED_TIME_ATTRIBUTE, CDATA, String.valueOf(elapsedTime));
                super.startElement(namespaceURI, localName, qName, (Attributes)this.documentAttributes);
                super.endElement(namespaceURI, localName, qName);
                this.processing = 1;
                return;
            }
            IndexHelperField tos = (IndexHelperField)this.elementStack.pop();
            StringBuffer text = tos.getText();
            Attributes atts = tos.getAttributes();
            boolean attributesToText = atts.getIndex(LUCENE_URI, LUCENE_ELEMENT_ATTR_TO_TEXT_ATTRIBUTE) != -1;
            for (int i = 0; i < atts.getLength(); ++i) {
                if (LUCENE_URI.equals(atts.getURI(i))) continue;
                String atts_lname = atts.getLocalName(i);
                String atts_value = atts.getValue(i);
                this.bodyDocument.add(Field.UnStored((String)(localName + "@" + atts_lname), (String)atts_value));
                if (!attributesToText) continue;
                text.append(atts_value);
                text.append(' ');
                this.bodyText.append(atts_value);
                this.bodyText.append(' ');
            }
            boolean bl = store = atts.getIndex(LUCENE_URI, LUCENE_ELEMENT_ATTR_STORE_VALUE) != -1;
            if (text == null || text.length() <= 0) return;
            if (store) {
                this.bodyDocument.add(Field.Text((String)localName, (String)text.toString()));
                return;
            } else {
                this.bodyDocument.add(Field.UnStored((String)localName, (String)text.toString()));
            }
            return;
        }
        super.endElement(namespaceURI, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.processing == 2 && ch.length > 0 && start >= 0 && length > 1 && this.elementStack.size() > 0) {
            String text = new String(ch, start, length);
            ((IndexHelperField)this.elementStack.peek()).append(text);
            this.bodyText.append(text);
            this.bodyText.append(' ');
        } else if (this.processing == 0) {
            super.characters(ch, start, length);
        }
    }

    private void openWriter() throws IOException {
        boolean indexExists;
        File indexDirectory = new File(this.queryConfiguration.indexDirectory);
        if (!indexDirectory.isAbsolute()) {
            indexDirectory = new File(this.workDir, this.queryConfiguration.indexDirectory);
        }
        if (!(indexExists = IndexReader.indexExists((File)indexDirectory))) {
            this.createIndex = true;
        }
        Directory directory = LuceneCocoonHelper.getDirectory(indexDirectory, this.createIndex);
        Analyzer analyzer = LuceneCocoonHelper.getAnalyzer(this.queryConfiguration.analyzerClassname);
        this.writer = new IndexWriter(directory, analyzer, this.createIndex);
        this.writer.mergeFactor = this.queryConfiguration.mergeFactor;
    }

    private IndexReader openReader() throws IOException {
        File indexDirectory = new File(this.queryConfiguration.indexDirectory);
        if (!indexDirectory.isAbsolute()) {
            indexDirectory = new File(this.workDir, this.queryConfiguration.indexDirectory);
        }
        Directory directory = LuceneCocoonHelper.getDirectory(indexDirectory, this.createIndex);
        IndexReader reader = IndexReader.open((Directory)directory);
        return reader;
    }

    private void reindexDocument() throws IOException {
        if (this.createIndex) {
            if (this.writer == null) {
                this.openWriter();
            }
            this.writer.addDocument(this.bodyDocument);
        } else {
            try {
                IndexReader reader = this.openReader();
                reader.delete(new Term("uid", LuceneIndexTransformer.uid(this.bodyDocumentURL)));
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.openWriter();
            this.writer.addDocument(this.bodyDocument);
            this.writer.close();
            this.writer = null;
        }
        this.bodyDocument = null;
    }

    class IndexerConfiguration {
        String analyzerClassname;
        String indexDirectory;
        int mergeFactor;

        public IndexerConfiguration(String analyzerClassname, String indexDirectory, int mergeFactor) {
            this.analyzerClassname = analyzerClassname;
            this.indexDirectory = indexDirectory;
            this.mergeFactor = mergeFactor;
        }
    }

    class IndexHelperField {
        String localName;
        StringBuffer text;
        Attributes attributes;

        IndexHelperField(String localName, Attributes atts) {
            this.localName = localName;
            this.attributes = atts;
            this.text = new StringBuffer();
        }

        public Attributes getAttributes() {
            return this.attributes;
        }

        public StringBuffer getText() {
            return this.text;
        }

        public void append(String text) {
            this.text.append(text);
        }

        public void append(char[] str, int offset, int length) {
            this.text.append(str, offset, length);
        }
    }
}

