/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

public class Trie {
    public static final int ALPHA_SIZE = 128;
    final Node m_Root;
    private char[] m_charBuffer = new char[0];
    private final boolean m_lowerCaseOnly;

    public Trie() {
        this.m_Root = new Node();
        this.m_lowerCaseOnly = false;
    }

    public Trie(boolean lowerCaseOnly) {
        this.m_Root = new Node();
        this.m_lowerCaseOnly = lowerCaseOnly;
    }

    public Object put(String key, Object value) {
        int len = key.length();
        if (len > this.m_charBuffer.length) {
            this.m_charBuffer = new char[len];
        }
        Node node = this.m_Root;
        for (int i = 0; i < len; ++i) {
            Node nextNode = node.m_nextChar[Character.toLowerCase(key.charAt(i))];
            if (nextNode != null) {
                node = nextNode;
                continue;
            }
            while (i < len) {
                Node newNode = new Node();
                if (this.m_lowerCaseOnly) {
                    node.m_nextChar[Character.toLowerCase((char)key.charAt((int)i))] = newNode;
                } else {
                    node.m_nextChar[Character.toUpperCase((char)key.charAt((int)i))] = newNode;
                    node.m_nextChar[Character.toLowerCase((char)key.charAt((int)i))] = newNode;
                }
                node = newNode;
                ++i;
            }
            break;
        }
        Object ret = node.m_Value;
        node.m_Value = value;
        return ret;
    }

    public Object get(String key) {
        int len = key.length();
        if (this.m_charBuffer.length < len) {
            return null;
        }
        Node node = this.m_Root;
        switch (len) {
            case 0: {
                return null;
            }
            case 1: {
                char ch = key.charAt(0);
                if (ch < '\u0080' && (node = node.m_nextChar[ch]) != null) {
                    return node.m_Value;
                }
                return null;
            }
        }
        for (int i = 0; i < len; ++i) {
            char ch = key.charAt(i);
            if ('\u0080' <= ch) {
                return null;
            }
            node = node.m_nextChar[ch];
            if (node != null) continue;
            return null;
        }
        return node.m_Value;
    }

    public Trie(Trie existingTrie) {
        this.m_Root = existingTrie.m_Root;
        this.m_lowerCaseOnly = existingTrie.m_lowerCaseOnly;
        int max = existingTrie.getLongestKeyLength();
        this.m_charBuffer = new char[max];
    }

    public Object get2(String key) {
        int len = key.length();
        if (this.m_charBuffer.length < len) {
            return null;
        }
        Node node = this.m_Root;
        switch (len) {
            case 0: {
                return null;
            }
            case 1: {
                char ch = key.charAt(0);
                if (ch < '\u0080' && (node = node.m_nextChar[ch]) != null) {
                    return node.m_Value;
                }
                return null;
            }
        }
        key.getChars(0, len, this.m_charBuffer, 0);
        for (int i = 0; i < len; ++i) {
            char ch = this.m_charBuffer[i];
            if ('\u0080' <= ch) {
                return null;
            }
            node = node.m_nextChar[ch];
            if (node != null) continue;
            return null;
        }
        return node.m_Value;
    }

    public int getLongestKeyLength() {
        return this.m_charBuffer.length;
    }

    private class Node {
        final Node[] m_nextChar = new Node[128];
        Object m_Value = null;

        Node() {
        }
    }
}

