/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.classloader.ClassLoaderManager;
import org.apache.cocoon.components.language.programming.Program;
import org.apache.cocoon.core.container.AbstractComponentHandler;
import org.apache.cocoon.core.container.ComponentHandler;

public class GeneratorSelector
extends AbstractLogEnabled
implements ThreadSafe,
Contextualizable,
Serviceable {
    public static String ROLE = "org.apache.cocoon.components.language.generator.ServerPages";
    private Context context;
    private ServiceManager serviceManager;
    protected final Map componentMapping = Collections.synchronizedMap(new HashMap());
    protected final Map componentHandlers = Collections.synchronizedMap(new HashMap());
    protected ClassLoaderManager classManager;

    public void contextualize(Context context) {
        this.context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.serviceManager = manager;
        this.classManager = (ClassLoaderManager)manager.lookup(ClassLoaderManager.ROLE);
        try {
            this.classManager.addDirectory((File)this.context.get((Object)"work-directory"));
        }
        catch (Exception e) {
            throw new ServiceException(ROLE, "Could not add repository to ClassLoaderManager", (Throwable)e);
        }
    }

    public Object select(Object hint) throws ServiceException {
        AbstractComponentHandler handler = (AbstractComponentHandler)this.componentHandlers.get(hint);
        if (handler == null) {
            throw new ServiceException(ROLE, "Could not find component for hint: " + hint);
        }
        try {
            Object component = handler.get();
            this.componentMapping.put(component, handler);
            return component;
        }
        catch (Exception ce) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Could not access component for hint: " + hint, (Throwable)ce);
            }
            throw new ServiceException(ROLE, "Could not access component for hint: " + hint, (Throwable)ce);
        }
    }

    public void release(Object component) {
        AbstractComponentHandler handler = (AbstractComponentHandler)this.componentMapping.remove(component);
        if (handler != null) {
            try {
                handler.put(component);
            }
            catch (Exception e) {
                this.getLogger().error("Error trying to release component", (Throwable)e);
            }
        }
    }

    public void addGenerator(ServiceManager newManager, Object hint, Program generator) throws Exception {
        try {
            ComponentHandler handler = generator.getHandler(newManager, this.context);
            handler.initialize();
            this.componentHandlers.put(hint, handler);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Adding " + generator.getName() + " for " + hint);
            }
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Could not set up Component for hint: " + hint, (Throwable)e);
            }
            throw e;
        }
    }

    public void removeGenerator(Object hint) {
        ComponentHandler handler = (ComponentHandler)this.componentHandlers.remove(hint);
        if (handler != null) {
            handler.dispose();
            this.classManager.reinstantiate();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Removing " + handler.getClass().getName() + " for " + hint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.serviceManager.release((Object)this.classManager);
        GeneratorSelector generatorSelector = this;
        synchronized (generatorSelector) {
            Iterator<Object> keys = this.componentHandlers.keySet().iterator();
            ArrayList keyList = new ArrayList();
            while (keys.hasNext()) {
                Object key = keys.next();
                AbstractComponentHandler handler = (AbstractComponentHandler)this.componentHandlers.get(key);
                handler.dispose();
                keyList.add(key);
            }
            keys = keyList.iterator();
            while (keys.hasNext()) {
                this.componentHandlers.remove(keys.next());
            }
            keyList.clear();
        }
    }
}

