/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.programming.java;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.classloader.ClassLoaderManager;
import org.apache.cocoon.components.language.LanguageException;
import org.apache.cocoon.components.language.markup.xsp.XSLTExtension;
import org.apache.cocoon.components.language.programming.CompiledProgrammingLanguage;
import org.apache.cocoon.components.language.programming.CompilerError;
import org.apache.cocoon.components.language.programming.LanguageCompiler;
import org.apache.cocoon.util.ClassUtils;
import org.apache.commons.lang.SystemUtils;

public class JavaLanguage
extends CompiledProgrammingLanguage
implements Initializable,
ThreadSafe,
Serviceable,
Disposable {
    private ClassLoaderManager classLoaderManager;
    protected ServiceManager manager = null;
    private String classpath;
    private String classLoaderClass;

    public String getSourceExtension() {
        return "java";
    }

    public String getObjectExtension() {
        return "class";
    }

    public void parameterize(Parameters params) throws ParameterException {
        super.parameterize(params);
        this.classLoaderClass = params.getParameter("class-loader", null);
        if (this.classLoaderClass != null) {
            try {
                this.classLoaderManager = (ClassLoaderManager)ClassUtils.newInstance((String)this.classLoaderClass);
            }
            catch (Exception e) {
                throw new ParameterException("Unable to load class loader: " + this.classLoaderClass, (Throwable)e);
            }
        }
        try {
            this.getLogger().debug("Looking up " + ClassLoaderManager.ROLE);
            this.classLoaderManager = (ClassLoaderManager)this.manager.lookup(ClassLoaderManager.ROLE);
        }
        catch (ServiceException e) {
            throw new ParameterException("Lookup of ClassLoaderManager failed", (Throwable)e);
        }
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void initialize() throws Exception {
        String systemExtClasspath;
        String systemBootClasspath = System.getProperty("sun.boot.class.path");
        String systemClasspath = SystemUtils.JAVA_CLASS_PATH;
        String systemExtDirs = SystemUtils.JAVA_EXT_DIRS;
        try {
            systemExtClasspath = this.expandDirs(systemExtDirs);
        }
        catch (Exception e) {
            systemExtClasspath = null;
            this.getLogger().warn("Could not expand Directory:" + systemExtDirs, (Throwable)e);
        }
        this.classpath = (((CompiledProgrammingLanguage)this).classpath != null ? File.pathSeparator + ((CompiledProgrammingLanguage)this).classpath : "") + (systemBootClasspath != null ? File.pathSeparator + systemBootClasspath : "") + (systemClasspath != null ? File.pathSeparator + systemClasspath : "") + (systemExtClasspath != null ? File.pathSeparator + systemExtClasspath : "");
    }

    protected Class loadProgram(String name, File baseDirectory) throws LanguageException {
        try {
            this.classLoaderManager.addDirectory(baseDirectory);
            return this.classLoaderManager.loadClass(name.replace(File.separatorChar, '.'));
        }
        catch (Exception e) {
            throw new LanguageException("Could not load class for program '" + name + "' due to a " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    protected void compile(String name, File baseDirectory, String encoding) throws LanguageException {
        try {
            LanguageCompiler compiler = (LanguageCompiler)this.compilerClass.newInstance();
            if (compiler instanceof LogEnabled) {
                ((LogEnabled)compiler).enableLogging(this.getLogger());
            }
            if (compiler instanceof Serviceable) {
                ((Serviceable)compiler).service(this.manager);
            }
            int pos = name.lastIndexOf(File.separatorChar);
            String filename = name.substring(pos + 1);
            String basePath = baseDirectory.getCanonicalPath();
            String filepath = basePath + File.separator + name + "." + this.getSourceExtension();
            compiler.setFile(filepath);
            compiler.setSource(basePath);
            compiler.setDestination(basePath);
            compiler.setClasspath(basePath + this.classpath);
            if (encoding != null) {
                compiler.setEncoding(encoding);
            }
            this.getLogger().debug("Compiling " + filepath);
            if (!compiler.compile()) {
                StringBuffer message = new StringBuffer("Error compiling ");
                message.append(filename);
                message.append(":\n");
                List errors = compiler.getErrors();
                CompilerError[] compilerErrors = new CompilerError[errors.size()];
                errors.toArray(compilerErrors);
                throw new LanguageException(message.toString(), filepath, compilerErrors);
            }
        }
        catch (InstantiationException e) {
            this.getLogger().warn("Could not instantiate the compiler", (Throwable)e);
            throw new LanguageException("Could not instantiate the compiler: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.getLogger().warn("Could not access the compiler class", (Throwable)e);
            throw new LanguageException("Could not access the compiler class: " + e.getMessage());
        }
        catch (IOException e) {
            this.getLogger().warn("Error during compilation", (Throwable)e);
            throw new LanguageException("Error during compilation: " + e.getMessage());
        }
        catch (ServiceException e) {
            this.getLogger().warn("Could not initialize the compiler", (Throwable)e);
            throw new LanguageException("Could not initialize the compiler: " + e.getMessage());
        }
    }

    public void doUnload(Object program) throws LanguageException {
        this.classLoaderManager.reinstantiate();
    }

    public String quoteString(String constant) {
        return XSLTExtension.escapeJavaString(constant);
    }

    private String expandDirs(String dirPaths) {
        StringTokenizer st = new StringTokenizer(dirPaths, File.pathSeparator);
        StringBuffer buffer = new StringBuffer();
        while (st.hasMoreTokens()) {
            String d = st.nextToken();
            File dir = new File(d);
            if (!dir.isDirectory()) {
                if (!this.getLogger().isWarnEnabled()) continue;
                this.getLogger().warn("Attempted to retrieve directory listing of non-directory " + dir.toString());
                continue;
            }
            File[] files = dir.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    String name = file.getName().toLowerCase();
                    return name.endsWith(".jar") || name.endsWith(".zip");
                }
            });
            for (int i = 0; i < files.length; ++i) {
                buffer.append(files[i]).append(File.pathSeparator);
            }
        }
        return buffer.toString();
    }

    public void dispose() {
        if (this.classLoaderClass == null && this.classLoaderManager != null) {
            this.manager.release((Object)this.classLoaderManager);
            this.classLoaderManager = null;
        }
    }
}

