/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.programming.java;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.cocoon.components.language.programming.CompilerError;
import org.apache.cocoon.components.language.programming.java.AbstractJavaCompiler;
import org.apache.cocoon.util.ClassUtils;
import org.apache.log.Hierarchy;
import sun.tools.javac.Main;

public class Javac
extends AbstractJavaCompiler {
    public static final String CLASSIC_CLASS = "sun.tools.javac.Main";
    public static final String MODERN_CLASS = "com.sun.tools.javac.Main";
    private boolean modern = false;

    public Javac() {
        try {
            ClassUtils.loadClass((String)MODERN_CLASS);
            this.modern = true;
        }
        catch (ClassNotFoundException e) {
            Hierarchy.getDefaultHierarchy().getLoggerFor("cocoon").debug("Javac connector could not find modern compiler -- falling back to classic.");
            try {
                ClassUtils.loadClass((String)CLASSIC_CLASS);
                this.modern = false;
            }
            catch (Exception ex) {
                Hierarchy.getDefaultHierarchy().getLoggerFor("cocoon").error("No compiler found in your classpath. Make sure you added 'tools.jar'", (Throwable)ex);
                throw new CascadingRuntimeException("No compiler found in your classpath. Make sure you added 'tools.jar'", (Throwable)ex);
            }
        }
    }

    protected Javac(boolean modern) {
        this.modern = modern;
    }

    public boolean compile() throws IOException {
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        Main compiler = new Main((OutputStream)err, "javac");
        boolean result = compiler.compile(this.toStringArray(this.fillArguments(new ArrayList())));
        this.errors = new ByteArrayInputStream(err.toByteArray());
        return result;
    }

    protected List parseStream(BufferedReader input) throws IOException {
        if (this.modern) {
            return this.parseModernStream(input);
        }
        return this.parseClassicStream(input);
    }

    protected List parseModernStream(BufferedReader input) throws IOException {
        ArrayList<CompilerError> errors = new ArrayList<CompilerError>();
        String line = null;
        StringBuffer buffer = null;
        while (true) {
            buffer = new StringBuffer();
            do {
                if ((line = input.readLine()) == null) {
                    if (buffer.length() > 0) {
                        errors.add(new CompilerError("\n" + buffer.toString()));
                    }
                    return errors;
                }
                buffer.append(line);
                buffer.append('\n');
            } while (!line.endsWith("^"));
            errors.add(this.parseModernError(buffer.toString()));
        }
    }

    private CompilerError parseModernError(String error) {
        StringTokenizer tokens = new StringTokenizer(error, ":");
        try {
            String pointer;
            int startcolumn;
            String file = tokens.nextToken();
            if (file.length() == 1) {
                file = file + ":" + tokens.nextToken();
            }
            int line = Integer.parseInt(tokens.nextToken());
            String message = tokens.nextToken("\n").substring(1);
            String context = tokens.nextToken("\n");
            int endcolumn = context.indexOf(" ", startcolumn = (pointer = tokens.nextToken("\n")).indexOf("^"));
            if (endcolumn == -1) {
                endcolumn = context.length();
            }
            return new CompilerError(file, false, line, startcolumn, line, endcolumn, message);
        }
        catch (NoSuchElementException nse) {
            return new CompilerError("no more tokens - could not parse error message: " + error);
        }
        catch (Exception nse) {
            return new CompilerError("could not parse error message: " + error);
        }
    }

    protected List parseClassicStream(BufferedReader input) throws IOException {
        ArrayList<CompilerError> errors = null;
        String line = null;
        StringBuffer buffer = null;
        while (true) {
            buffer = new StringBuffer();
            for (int i = 0; i < 3; ++i) {
                line = input.readLine();
                if (line == null) {
                    return errors;
                }
                buffer.append(line);
                buffer.append('\n');
            }
            if (errors == null) {
                errors = new ArrayList<CompilerError>();
            }
            errors.add(this.parseClassicError(buffer.toString()));
        }
    }

    private CompilerError parseClassicError(String error) {
        StringTokenizer tokens = new StringTokenizer(error, ":");
        try {
            String pointer;
            int startcolumn;
            String file = tokens.nextToken();
            if (file.length() == 1) {
                file = file + ":" + tokens.nextToken();
            }
            int line = Integer.parseInt(tokens.nextToken());
            String last = tokens.nextToken();
            while (tokens.hasMoreElements()) {
                last = last + tokens.nextToken();
            }
            tokens = new StringTokenizer(last.trim(), "\n");
            String message = tokens.nextToken();
            String context = tokens.nextToken();
            int endcolumn = context.indexOf(" ", startcolumn = (pointer = tokens.nextToken()).indexOf("^"));
            if (endcolumn == -1) {
                endcolumn = context.length();
            }
            return new CompilerError(this.srcDir + File.separator + file, true, line, startcolumn, line, endcolumn, message);
        }
        catch (NoSuchElementException nse) {
            return new CompilerError("no more tokens - could not parse error message: " + error);
        }
        catch (Exception nse) {
            return new CompilerError("could not parse error message: " + error);
        }
    }

    public String toString() {
        return "Sun Javac Compiler";
    }
}

