/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.text;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class Interpolation {
    private static final String SYMBOLIC_VALUE_MARKER_START = "${";
    private static final String SYMBOLIC_VALUE_MARKER_END = "}";

    public static String interpolate(String templateString, Map valuesMap) {
        if (templateString == null || valuesMap == null || templateString.length() == 0 || valuesMap.isEmpty()) {
            return templateString;
        }
        String returnString = templateString;
        String nextKey = null;
        String substitutionValue = null;
        String nextValueToBeSubstituted = null;
        Iterator keys = valuesMap.keySet().iterator();
        while (keys.hasNext()) {
            nextKey = (String)keys.next();
            substitutionValue = StringUtils.defaultString((String)valuesMap.get(nextKey));
            nextValueToBeSubstituted = SYMBOLIC_VALUE_MARKER_START + nextKey + SYMBOLIC_VALUE_MARKER_END;
            returnString = StringUtils.replace(returnString, nextValueToBeSubstituted, substitutionValue);
        }
        return returnString;
    }

    public static String interpolateRepeatedly(String templateString, Map valuesMap) {
        if (templateString == null || valuesMap == null || templateString.length() == 0 || valuesMap.isEmpty()) {
            return templateString;
        }
        String currentResult = templateString;
        String previousResult = null;
        while (!StringUtils.equals(currentResult, previousResult)) {
            previousResult = currentResult;
            currentResult = Interpolation.interpolate(previousResult, valuesMap);
        }
        return currentResult;
    }
}

