/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;

public class StrTokenizer
implements ListIterator,
Cloneable {
    public static final Matcher COMMA_MATCHER = new CharMatcher(',');
    public static final Matcher TAB_MATCHER = new CharMatcher('\t');
    public static final Matcher SPACE_MATCHER = new CharMatcher(' ');
    public static final Matcher SPLIT_MATCHER = StrTokenizer.createCharSetMatcher(" \t\n\r\f");
    public static final Matcher SINGLE_QUOTE_MATCHER = new CharMatcher('\'');
    public static final Matcher DOUBLE_QUOTE_MATCHER = new CharMatcher('\"');
    public static final Matcher TRIM_MATCHER = new TrimMatcher();
    public static final Matcher NONE_MATCHER = new NoMatcher();
    private static final StrTokenizer CSV_TOKENIZER_PROTOTYPE = new StrTokenizer();
    private static final StrTokenizer TSV_TOKENIZER_PROTOTYPE;
    private char[] chars;
    private String text;
    private String[] tokens;
    private int tokenPos;
    private Matcher delim = SPLIT_MATCHER;
    private Matcher quote = NONE_MATCHER;
    private Matcher ignored = NONE_MATCHER;
    private boolean emptyAsNull = false;
    private boolean ignoreEmptyTokens = true;

    public static Matcher createCharSetMatcher(char[] chars) {
        if (chars == null || chars.length == 0) {
            throw new IllegalArgumentException("Characters must not be null or empty");
        }
        if (chars.length == 1) {
            return new CharMatcher(chars[0]);
        }
        return new CharSetMatcher(chars);
    }

    public static Matcher createCharSetMatcher(String chars) {
        if (chars == null || chars.length() == 0) {
            throw new IllegalArgumentException("Characters must not be null or empty");
        }
        if (chars.length() == 1) {
            return new CharMatcher(chars.charAt(0));
        }
        return new CharSetMatcher(chars.toCharArray());
    }

    public static Matcher createCharMatcher(char ch) {
        return new CharMatcher(ch);
    }

    public static Matcher createStringMatcher(String str) {
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException("String must not be null or empty");
        }
        return new StringMatcher(str);
    }

    public static StrTokenizer getCSVInstance() {
        return (StrTokenizer)CSV_TOKENIZER_PROTOTYPE.clone();
    }

    public static StrTokenizer getCSVInstance(String input) {
        StrTokenizer tok = (StrTokenizer)CSV_TOKENIZER_PROTOTYPE.clone();
        tok.reset(input);
        return tok;
    }

    public static StrTokenizer getCSVInstance(char[] input) {
        StrTokenizer tok = (StrTokenizer)CSV_TOKENIZER_PROTOTYPE.clone();
        tok.reset(input);
        return tok;
    }

    public static StrTokenizer getTSVInstance() {
        return (StrTokenizer)TSV_TOKENIZER_PROTOTYPE.clone();
    }

    public static StrTokenizer getTSVInstance(String input) {
        StrTokenizer tok = (StrTokenizer)TSV_TOKENIZER_PROTOTYPE.clone();
        tok.reset(input);
        return tok;
    }

    public static StrTokenizer getTSVInstance(char[] input) {
        StrTokenizer tok = (StrTokenizer)TSV_TOKENIZER_PROTOTYPE.clone();
        tok.reset(input);
        return tok;
    }

    public StrTokenizer() {
        this.text = "";
        this.chars = new char[0];
    }

    public StrTokenizer(String input) {
        this.text = input;
        this.chars = input.toCharArray();
    }

    public StrTokenizer(String input, char delim) {
        this(input);
        this.setDelimiterChar(delim);
    }

    public StrTokenizer(String input, String delim) {
        this(input);
        this.setDelimiterString(delim);
    }

    public StrTokenizer(String input, Matcher delim) {
        this(input);
        this.setDelimiterMatcher(delim);
    }

    public StrTokenizer(String input, char delim, char quote) {
        this(input, delim);
        this.setQuoteChar(quote);
    }

    public StrTokenizer(String input, Matcher delim, Matcher quote) {
        this(input, delim);
        this.setQuoteMatcher(quote);
    }

    public StrTokenizer(char[] input) {
        this.text = null;
        this.chars = (char[])input.clone();
    }

    public StrTokenizer(char[] input, char delim) {
        this(input);
        this.setDelimiterChar(delim);
    }

    public StrTokenizer(char[] input, String delim) {
        this(input);
        this.setDelimiterString(delim);
    }

    public StrTokenizer(char[] input, Matcher delim) {
        this(input);
        this.setDelimiterMatcher(delim);
    }

    public StrTokenizer(char[] input, char delim, char quote) {
        this(input, delim);
        this.setQuoteChar(quote);
    }

    public StrTokenizer(char[] input, Matcher delim, Matcher quote) {
        this(input, delim);
        this.setQuoteMatcher(quote);
    }

    public int size() {
        this.tokenize();
        return this.tokens.length;
    }

    public String nextToken() {
        if (this.hasNext()) {
            return this.tokens[this.tokenPos++];
        }
        return null;
    }

    public String previousToken() {
        if (this.hasPrevious()) {
            return this.tokens[--this.tokenPos];
        }
        return null;
    }

    public String[] getAllTokens() {
        this.tokenize();
        return (String[])this.tokens.clone();
    }

    public void reset() {
        this.tokenPos = 0;
        this.tokens = null;
    }

    public void reset(String input) {
        this.reset();
        this.text = input;
        this.chars = input.toCharArray();
    }

    public void reset(char[] input) {
        this.reset();
        this.text = null;
        this.chars = (char[])input.clone();
    }

    public boolean hasNext() {
        this.tokenize();
        return this.tokenPos < this.tokens.length;
    }

    public Object next() {
        return this.nextToken();
    }

    public int nextIndex() {
        return this.tokenPos;
    }

    public boolean hasPrevious() {
        this.tokenize();
        return this.tokenPos > 0;
    }

    public Object previous() {
        return this.previousToken();
    }

    public int previousIndex() {
        return this.tokenPos - 1;
    }

    public void remove() {
        throw new UnsupportedOperationException("remove() is unsupported");
    }

    public void set(Object obj) {
        throw new UnsupportedOperationException("set() is unsupported");
    }

    public void add(Object obj) {
        throw new UnsupportedOperationException("add() is unsupported");
    }

    private void tokenize() {
        if (this.tokens == null) {
            this.tokens = this.readTokens();
        }
    }

    private String[] readTokens() {
        int len = this.chars.length;
        char[] cbuf = new char[len];
        StringBuffer token = new StringBuffer();
        int start = 0;
        ArrayList tokens = new ArrayList();
        String tok = null;
        while (start < len) {
            start = this.readNextToken(start, cbuf, token);
            tok = token.toString();
            this.addToken(tokens, tok);
            token.setLength(0);
            if (start != len || this.delim.isMatch(this.chars, len, start - 1) != 1) continue;
            this.addToken(tokens, "");
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private void addToken(List list, String tok) {
        if (tok == null || tok.length() == 0) {
            if (this.ignoreEmptyTokens) {
                return;
            }
            if (this.emptyAsNull) {
                tok = null;
            }
        }
        list.add(tok);
    }

    private int readNextToken(int start, char[] cbuf, StringBuffer token) {
        token.setLength(0);
        int len = this.chars.length;
        int ignoreLen = 0;
        int delimLen = 0;
        int quoteLen = 0;
        while (start < len && (ignoreLen = this.ignored.isMatch(this.chars, len, start)) >= 1 && (delimLen = this.delim.isMatch(this.chars, len, start)) < 1 && (quoteLen = this.quote.isMatch(this.chars, len, start)) < 1) {
            start += ignoreLen;
        }
        if (start >= len) {
            return start;
        }
        delimLen = this.delim.isMatch(this.chars, len, start);
        start = delimLen >= 1 ? (start += delimLen) : ((quoteLen = this.quote.isMatch(this.chars, len, start)) >= 1 ? this.readQuoted(start + quoteLen, cbuf, token) : this.readUnquoted(start, token));
        return start;
    }

    private int readQuoted(int start, char[] cbuf, StringBuffer token) {
        int cbufcnt = 0;
        int pos = start;
        boolean done = false;
        boolean quoting = true;
        int len = this.chars.length;
        int delimLen = 0;
        int quoteLen = 0;
        while (pos < len && !done) {
            if (quoting) {
                quoteLen = this.quote.isMatch(this.chars, len, pos);
                if (quoteLen >= 1) {
                    if (pos + 1 < len && this.chars[pos + 1] == this.chars[pos]) {
                        cbuf[cbufcnt++] = this.chars[pos];
                        pos += 2;
                        continue;
                    }
                    quoting = false;
                    pos += quoteLen;
                    continue;
                }
                cbuf[cbufcnt++] = this.chars[pos];
                ++pos;
                continue;
            }
            delimLen = this.delim.isMatch(this.chars, len, pos);
            if (delimLen >= 1) {
                done = true;
                continue;
            }
            quoteLen = this.quote.isMatch(this.chars, len, pos);
            if (quoteLen >= 1) {
                quoting = true;
                pos += quoteLen;
                continue;
            }
            cbuf[cbufcnt++] = this.chars[pos];
            ++pos;
        }
        token.append(cbuf, 0, cbufcnt);
        return pos + delimLen;
    }

    private int readUnquoted(int start, StringBuffer token) {
        int pos;
        char[] chars = this.chars;
        int len = chars.length;
        int delimLen = 0;
        for (pos = start; pos < len && (delimLen = this.delim.isMatch(chars, len, pos)) < 1; ++pos) {
        }
        token.append(chars, start, Math.min(pos, len) - start);
        return pos + delimLen;
    }

    public Matcher getDelimiterMatcher() {
        return this.delim;
    }

    public void setDelimiterMatcher(Matcher delim) {
        this.delim = delim == null ? NONE_MATCHER : delim;
    }

    public void setDelimiterChar(char delim) {
        this.setDelimiterMatcher(new CharMatcher(delim));
    }

    public void setDelimiterString(String delim) {
        if (delim == null || delim.length() == 0) {
            this.setDelimiterMatcher(NONE_MATCHER);
        } else if (delim.length() == 1) {
            this.setDelimiterMatcher(new CharMatcher(delim.charAt(0)));
        } else {
            this.setDelimiterMatcher(new StringMatcher(delim));
        }
    }

    public Matcher getQuoteMatcher() {
        return this.quote;
    }

    public void setQuoteMatcher(Matcher quote) {
        if (quote != null) {
            this.quote = quote;
        }
    }

    public void setQuoteChar(char quote) {
        this.setQuoteMatcher(new CharMatcher(quote));
    }

    public Matcher getIgnoredMatcher() {
        return this.ignored;
    }

    public void setIgnoredMatcher(Matcher ignored) {
        if (ignored != null) {
            this.ignored = ignored;
        }
    }

    public void setIgnoredChar(char ignored) {
        this.setIgnoredMatcher(new CharMatcher(ignored));
    }

    public boolean isEmptyTokenAsNull() {
        return this.emptyAsNull;
    }

    public void setEmptyTokenAsNull(boolean emptyAsNull) {
        this.emptyAsNull = emptyAsNull;
    }

    public boolean isIgnoreEmptyTokens() {
        return this.ignoreEmptyTokens;
    }

    public void setIgnoreEmptyTokens(boolean ignoreEmptyTokens) {
        this.ignoreEmptyTokens = ignoreEmptyTokens;
    }

    public String getContent() {
        if (this.text == null) {
            this.text = new String(this.chars);
        }
        return this.text;
    }

    public Object clone() {
        try {
            StrTokenizer cloned = (StrTokenizer)super.clone();
            cloned.reset();
            return cloned;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    static {
        CSV_TOKENIZER_PROTOTYPE.setDelimiterMatcher(COMMA_MATCHER);
        CSV_TOKENIZER_PROTOTYPE.setQuoteMatcher(DOUBLE_QUOTE_MATCHER);
        CSV_TOKENIZER_PROTOTYPE.setIgnoredMatcher(TRIM_MATCHER);
        CSV_TOKENIZER_PROTOTYPE.setEmptyTokenAsNull(false);
        CSV_TOKENIZER_PROTOTYPE.setIgnoreEmptyTokens(false);
        TSV_TOKENIZER_PROTOTYPE = new StrTokenizer();
        TSV_TOKENIZER_PROTOTYPE.setDelimiterMatcher(TAB_MATCHER);
        TSV_TOKENIZER_PROTOTYPE.setQuoteMatcher(DOUBLE_QUOTE_MATCHER);
        TSV_TOKENIZER_PROTOTYPE.setIgnoredMatcher(TRIM_MATCHER);
        TSV_TOKENIZER_PROTOTYPE.setEmptyTokenAsNull(false);
        TSV_TOKENIZER_PROTOTYPE.setIgnoreEmptyTokens(false);
    }

    static final class TrimMatcher
    implements Matcher {
        TrimMatcher() {
        }

        public int isMatch(char[] text, int textLen, int pos) {
            return text[pos] <= ' ' ? 1 : 0;
        }
    }

    static final class NoMatcher
    implements Matcher {
        NoMatcher() {
        }

        public int isMatch(char[] text, int textLen, int pos) {
            return 0;
        }
    }

    static final class StringMatcher
    implements Matcher {
        private char[] chars;

        StringMatcher(String str) {
            this.chars = str.toCharArray();
        }

        public int isMatch(char[] text, int textLen, int pos) {
            int len = this.chars.length;
            if (pos + len >= textLen) {
                return 0;
            }
            int i = 0;
            while (i < this.chars.length) {
                if (this.chars[i] != text[pos]) {
                    return 0;
                }
                ++i;
                ++pos;
            }
            return len;
        }
    }

    static final class CharMatcher
    implements Matcher {
        private char ch;

        CharMatcher(char ch) {
            this.ch = ch;
        }

        public int isMatch(char[] text, int textLen, int pos) {
            return this.ch == text[pos] ? 1 : 0;
        }
    }

    static final class CharSetMatcher
    implements Matcher {
        private char[] chars;

        CharSetMatcher(char[] chars) {
            this.chars = (char[])chars.clone();
            Arrays.sort(this.chars);
        }

        public int isMatch(char[] text, int textLen, int pos) {
            return Arrays.binarySearch(this.chars, text[pos]) >= 0 ? 1 : 0;
        }
    }

    public static interface Matcher {
        public int isMatch(char[] var1, int var2, int var3);
    }
}

