/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.time;

import org.apache.commons.lang.StringUtils;

class Token {
    private Object value;
    private int count;

    static boolean containsTokenWithValue(Token[] tokens, Object value) {
        int sz = tokens.length;
        for (int i = 0; i < sz; ++i) {
            if (tokens[i].getValue() != value) continue;
            return true;
        }
        return false;
    }

    public Token(Object value) {
        this.value = value;
        this.count = 1;
    }

    Token(Object value, int count) {
        this.value = value;
        this.count = count;
    }

    public void increment() {
        ++this.count;
    }

    public int getCount() {
        return this.count;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object obj2) {
        if (obj2 instanceof Token) {
            Token tok2 = (Token)obj2;
            if (this.value.getClass() != tok2.value.getClass()) {
                return false;
            }
            if (this.count != tok2.count) {
                return false;
            }
            if (this.value instanceof StringBuffer) {
                return this.value.toString().equals(tok2.value.toString());
            }
            if (this.value instanceof Number) {
                return this.value.equals(tok2.value);
            }
            return this.value == tok2.value;
        }
        return false;
    }

    public String toString() {
        return StringUtils.repeat(this.value.toString(), this.count);
    }
}

