/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.dom;

import org.openxml.dom.AttrImpl;
import org.openxml.dom.DOMExceptionImpl;
import org.openxml.dom.ElementImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class AttrNodeMap
implements NamedNodeMap {
    private ElementImpl _elem;

    AttrNodeMap(ElementImpl elementImpl) {
        if (elementImpl == null) {
            throw new NullPointerException("Argument 'elem' is null.");
        }
        this._elem = elementImpl;
    }

    public int getLength() {
        return this._elem._attrCount;
    }

    public synchronized Node getNamedItem(String string) {
        return this._elem.getNamedAttr(string);
    }

    public Node item(int n) {
        AttrImpl attrImpl = this._elem._firstAttr;
        while (attrImpl != null && n > 0) {
            attrImpl = (AttrImpl)attrImpl._nextNode;
            --n;
        }
        return attrImpl;
    }

    public synchronized Node removeNamedItem(String string) throws DOMException {
        AttrImpl attrImpl = this._elem.getNamedAttr(string);
        if (attrImpl != null) {
            this._elem.removeAttr(attrImpl);
            return attrImpl;
        }
        return null;
    }

    public synchronized Node setNamedItem(Node node) throws DOMException {
        if (!(node instanceof AttrImpl)) {
            throw new DOMExceptionImpl(3, "Node is not an attribute compatible with this element.");
        }
        return this._elem.setAttributeNode((AttrImpl)node);
    }
}

