/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.source.holders;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.openxml.source.Source;
import org.openxml.source.holders.HolderImpl;

final class URLHolderImpl
extends HolderImpl {
    private long _lastModified;
    private boolean _canCache;

    URLHolderImpl(URL uRL, String string, String string2, Class clazz) throws IOException {
        super(string, string2, clazz);
        int n;
        URLConnection uRLConnection = uRL.openConnection();
        this._lastModified = uRLConnection.getLastModified();
        this._canCache = uRLConnection.getUseCaches();
        this._encoding = uRLConnection.getContentEncoding();
        String string3 = uRLConnection.getContentType();
        if (string3 != null && this._docClass == null) {
            if (string3.equalsIgnoreCase("text/html")) {
                this._docClass = Source.DOCUMENT_HTML;
            } else if (string3.equalsIgnoreCase("text/xml") || string3.equalsIgnoreCase("application/xml")) {
                this._docClass = Source.DOCUMENT_XML;
            } else if (string3.equalsIgnoreCase("text/xml-dtd") || string3.equalsIgnoreCase("application/xml-dtd")) {
                this._docClass = Source.DOCUMENT_DTD;
            }
        }
        if (this._docClass == null && (n = this._uri.lastIndexOf(46)) > 0) {
            string3 = this._uri.substring(n);
            if (string3.equalsIgnoreCase(".htm") || string3.equalsIgnoreCase(".html")) {
                this._docClass = Source.DOCUMENT_HTML;
            } else if (string3.equalsIgnoreCase(".xml") || string3.equalsIgnoreCase(".dom")) {
                this._docClass = Source.DOCUMENT_XML;
            }
            if (string3.equalsIgnoreCase(".dtd")) {
                this._docClass = Source.DOCUMENT_DTD;
            }
        }
    }

    public boolean canCache() {
        return this._canCache;
    }

    public boolean hasModified() {
        try {
            return new URL(this._uri).openConnection().getLastModified() > this._lastModified;
        }
        catch (Exception exception) {
            return true;
        }
    }
}

