/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.Collection;
import jdepend.framework.JDepend;
import jdepend.framework.JDependTestCase;
import jdepend.framework.JavaPackage;

public class ComponentTest
extends JDependTestCase {
    private JDepend jdepend;
    private static NumberFormat formatter = NumberFormat.getInstance();

    public ComponentTest(String name) {
        super(name);
    }

    protected void setUp() {
        super.setUp();
        this.jdepend = new JDepend();
        this.jdepend.analyzeInnerClasses(false);
    }

    protected void tearDown() {
        super.tearDown();
    }

    public void testJDependComponents() throws IOException {
        this.jdepend.setComponents("jdepend,junit,java,javax");
        this.jdepend.addDirectory(this.getBuildDir());
        this.jdepend.analyze();
        Collection packages = this.jdepend.getPackages();
        ComponentTest.assertEquals((int)4, (int)packages.size());
        this.assertJDependPackage();
        this.assertJUnitPackage();
        this.assertJavaPackage();
        this.assertJavaxPackage();
    }

    private void assertJDependPackage() {
        JavaPackage p = this.jdepend.getPackage("jdepend");
        ComponentTest.assertEquals((String)"jdepend", (String)p.getName());
        ComponentTest.assertEquals((int)34, (int)p.getConcreteClassCount());
        ComponentTest.assertEquals((int)5, (int)p.getAbstractClassCount());
        ComponentTest.assertEquals((int)0, (int)p.afferentCoupling());
        ComponentTest.assertEquals((int)3, (int)p.efferentCoupling());
        ComponentTest.assertEquals((String)this.format(0.13f), (String)this.format(p.abstractness()));
        ComponentTest.assertEquals((String)"1", (String)this.format(p.instability()));
        ComponentTest.assertEquals((String)this.format(0.13f), (String)this.format(p.distance()));
        ComponentTest.assertEquals((int)1, (int)p.getVolatility());
        Collection efferents = p.getEfferents();
        ComponentTest.assertEquals((int)3, (int)efferents.size());
        ComponentTest.assertTrue((boolean)efferents.contains(new JavaPackage("java")));
        ComponentTest.assertTrue((boolean)efferents.contains(new JavaPackage("javax")));
        ComponentTest.assertTrue((boolean)efferents.contains(new JavaPackage("junit")));
        Collection afferents = p.getAfferents();
        ComponentTest.assertEquals((int)0, (int)afferents.size());
    }

    private void assertJUnitPackage() {
        JavaPackage p = this.jdepend.getPackage("junit");
        ComponentTest.assertEquals((String)"junit", (String)p.getName());
        Collection afferents = p.getAfferents();
        ComponentTest.assertEquals((int)1, (int)afferents.size());
        ComponentTest.assertTrue((boolean)afferents.contains(new JavaPackage("jdepend")));
        Collection efferents = p.getEfferents();
        ComponentTest.assertEquals((int)0, (int)efferents.size());
    }

    private void assertJavaPackage() {
        JavaPackage p = this.jdepend.getPackage("java");
        ComponentTest.assertEquals((String)"java", (String)p.getName());
        Collection afferents = p.getAfferents();
        ComponentTest.assertEquals((int)1, (int)afferents.size());
        ComponentTest.assertTrue((boolean)afferents.contains(new JavaPackage("jdepend")));
        Collection efferents = p.getEfferents();
        ComponentTest.assertEquals((int)0, (int)efferents.size());
    }

    private void assertJavaxPackage() {
        JavaPackage p = this.jdepend.getPackage("javax");
        ComponentTest.assertEquals((String)"javax", (String)p.getName());
        Collection afferents = p.getAfferents();
        ComponentTest.assertEquals((int)1, (int)afferents.size());
        ComponentTest.assertTrue((boolean)afferents.contains(new JavaPackage("jdepend")));
        Collection efferents = p.getEfferents();
        ComponentTest.assertEquals((int)0, (int)efferents.size());
    }

    private String format(float f) {
        return formatter.format(f);
    }

    static {
        formatter.setMaximumFractionDigits(2);
    }
}

