/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.connector;

import java.io.IOException;
import java.util.Set;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

/**
 * The interface for generic MBeanServers.
 *
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.1 $
 * @deprecated
 */
public interface MBeanServerConnection
{
	public void addNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback)
			throws InstanceNotFoundException, IOException;

	public void removeNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback)
			throws InstanceNotFoundException, ListenerNotFoundException, IOException;

	public ObjectInstance createMBean(String className, ObjectName objectName, Object[] args, String[] parameters)
			throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException;

	public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName, Object[] args, String[] parameters)
			throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException;

	public void unregisterMBean(ObjectName objectName)
			throws InstanceNotFoundException, MBeanRegistrationException, IOException;

	public Object getAttribute(ObjectName objectName, String attribute)
			throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException;

	public void setAttribute(ObjectName objectName, Attribute attribute)
			throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException;

	public AttributeList getAttributes(ObjectName objectName, String[] attributes)
			throws InstanceNotFoundException, ReflectionException, IOException;

	public AttributeList setAttributes(ObjectName objectName, AttributeList attributes)
			throws InstanceNotFoundException, ReflectionException, IOException;

	public Object invoke(ObjectName objectName, String methodName, Object[] args, String[] parameters)
			throws InstanceNotFoundException, MBeanException, ReflectionException, IOException;

	public String getDefaultDomain() throws IOException;

	public Integer getMBeanCount() throws IOException;

	public boolean isRegistered(ObjectName objectname) throws IOException;

	public MBeanInfo getMBeanInfo(ObjectName objectName)
			throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException;

	public ObjectInstance getObjectInstance(ObjectName objectName)
			throws InstanceNotFoundException, IOException;

	public boolean isInstanceOf(ObjectName objectName, String className)
			throws InstanceNotFoundException, IOException;

	public Set queryMBeans(ObjectName patternName, QueryExp filter) throws IOException;

	public Set queryNames(ObjectName patternName, QueryExp filter) throws IOException;
}
