(*  Copyright (c) 2001 Anthony L Shipman *)


structure Main=
struct
    structure FS = OS.FileSys
    structure OP = OS.Path

    fun toErr msg = TextIO.output(TextIO.stdErr, msg)

    exception Error of string


    fun open_dir dir =
    (
	FS.openDir dir
    )
    handle 
      OS.SysErr (msg, _) => raise Error (concat[
		"Cannot open directory ", dir, ": ", msg, "\n"])


    fun scan_dir dir =
    let
	(* val _ = print(concat["scan_dir ", dir, "\n"]) *)
	val strm = open_dir dir

	fun get_files files =
	(
	    case FS.readDir strm of
	      "" => rev files		(* done *)

	    | f => 
		let
		    val file = OP.joinDirFile
				{dir = dir, file = f}
		in
		    if FS.isLink file
		    then
			get_files files
		    else
			get_files (file::files)
		end
	)

	val files = get_files []
	val _     = FS.closeDir strm

	fun show_wx file =
	(
	    if FS.access(file, [FS.A_WRITE, FS.A_EXEC])
	    then
		(print file; print "\n")
	    else
		()
	)

	fun scan_subdir file =
	(
	    if FS.isDir file
	    then
		scan_dir file
	    else
		()
	)
    in
	app show_wx files;
	app scan_subdir files
    end


    fun main(arg0, argv) =
    let
    in
	case argv of
	  [] => scan_dir OP.currentArc

	| (file::_) => scan_dir file;

        OS.Process.success
    end
    handle
      OS.SysErr (msg, _) =>
	(
	    toErr(concat["System Error: ", msg, "\n"]);
	    OS.Process.failure
	)

    | Error msg => (toErr msg; OS.Process.failure)

    | x => (toErr(concat["Uncaught exception: ", exnMessage x,"\n"]);
    	    OS.Process.failure)


    val _ = SMLofNJ.exportFn("scanwx", main)
end
