(*  Copyright (c) 2001 Anthony L Shipman *)


structure Main=
struct

    fun toErr s = TextIO.output(TextIO.stdErr, s)

    val strings = [ "fred",
    		    "wilma",
		    "barney",
		    "betty",
    		    "wilma",
		    "pebbles",
		    "bambam"
		]


    fun sort_strings (data: string list) =
    (
	ListMergeSort.sort (op >) data
    )


    fun unique_strings (data: string list) =
    (
	ListMergeSort.uniqueSort String.compare data
    )

    fun show_list lst =
    (
	app (fn s => (print " "; print s)) lst;
	print "\n"
    )


    local
	datatype Gender = Male | Female

	type Pair = string * Gender

	(*  Compare two pairs. *)
	fun compare ((n1, _), (n2, _)) = String.compare(n1, n2)

	structure PairArray = MonoArrayFn(type elem = Pair)
	structure Searcher  = BSearchFn(PairArray)
	structure Sorter    = ArrayQSortFn(PairArray)

	val gender = [  ("fred",	Male),
			("wilma",	Female),
			("barney",	Male),
			("betty",	Female),
			("wilma",	Female),
			("pebbles",	Female),
			("bambam",	Male)
		    ]

	val sorted_gender = PairArray.fromList gender
	val _ = Sorter.sort compare sorted_gender
    in
	fun find_gender name =
	let
	    (* Compare a key with a pair *)
	    fun cmp (key, (n, _)) = String.compare(key, n)
	in
	    case Searcher.bsearch cmp (name, sorted_gender) of
	      NONE             => NONE
	    | SOME (_, (_, g)) => SOME g
	end


	fun show_gender Male   = "male"
	|   show_gender Female = "female"
    end



    fun main(arg0, argv) =
    (
	show_list(sort_strings strings);
	show_list(unique_strings strings);

	let
	    fun get name =
		case find_gender name of
		  NONE   => "unknown"
		| SOME g => show_gender g
	in
	    print(concat["The gender of wilma is ", get "wilma", "\n"])
	end;

	OS.Process.success
    )
    handle x =>
    (
	toErr(exnMessage x); toErr("\n");
	OS.Process.failure
    )

    val _ = SMLofNJ.exportFn("sort", main)
end
